@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Policy to set request timeouts
 * @property connectionTimeoutInSeconds Timeout, in seconds, for a request to initiate a connection
 * @property responseTimeoutInSeconds Timeout, in seconds, for a request to respond
 */
public data class TimeoutPolicyResponse(
    public val connectionTimeoutInSeconds: Int? = null,
    public val responseTimeoutInSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.TimeoutPolicyResponse): TimeoutPolicyResponse = TimeoutPolicyResponse(
            connectionTimeoutInSeconds = javaType.connectionTimeoutInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            responseTimeoutInSeconds = javaType.responseTimeoutInSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
