@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getEvidencePlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getProviderActionCollectionCountPlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getProviderActionOverviewStatusPlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getReportPlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getReportScopingQuestionsPlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getScopingConfigurationPlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.getWebhookPlain
import com.pulumi.azurenative.appcomplianceautomation.AppcomplianceautomationFunctions.listProviderActionInUseStorageAccountsPlain
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetEvidencePlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetEvidencePlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetProviderActionCollectionCountPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetProviderActionCollectionCountPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetProviderActionOverviewStatusPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetProviderActionOverviewStatusPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetReportPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetReportPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetReportScopingQuestionsPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetReportScopingQuestionsPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetScopingConfigurationPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetScopingConfigurationPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetWebhookPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.GetWebhookPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.ListProviderActionInUseStorageAccountsPlainArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.ListProviderActionInUseStorageAccountsPlainArgsBuilder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetEvidenceResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetProviderActionCollectionCountResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetProviderActionOverviewStatusResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetReportResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetReportScopingQuestionsResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetScopingConfigurationResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetWebhookResult
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ListProviderActionInUseStorageAccountsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetEvidenceResult.Companion.toKotlin as getEvidenceResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetProviderActionCollectionCountResult.Companion.toKotlin as getProviderActionCollectionCountResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetProviderActionOverviewStatusResult.Companion.toKotlin as getProviderActionOverviewStatusResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetReportResult.Companion.toKotlin as getReportResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetReportScopingQuestionsResult.Companion.toKotlin as getReportScopingQuestionsResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetScopingConfigurationResult.Companion.toKotlin as getScopingConfigurationResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.GetWebhookResult.Companion.toKotlin as getWebhookResultToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ListProviderActionInUseStorageAccountsResult.Companion.toKotlin as listProviderActionInUseStorageAccountsResultToKotlin

public object AppcomplianceautomationFunctions {
    /**
     * Get the evidence metadata
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return A class represent an AppComplianceAutomation evidence resource.
     */
    public suspend fun getEvidence(argument: GetEvidencePlainArgs): GetEvidenceResult =
        getEvidenceResultToKotlin(getEvidencePlain(argument.toJava()).await())

    /**
     * @see [getEvidence].
     * @param evidenceName The evidence name.
     * @param reportName Report Name.
     * @return A class represent an AppComplianceAutomation evidence resource.
     */
    public suspend fun getEvidence(evidenceName: String, reportName: String): GetEvidenceResult {
        val argument = GetEvidencePlainArgs(
            evidenceName = evidenceName,
            reportName = reportName,
        )
        return getEvidenceResultToKotlin(getEvidencePlain(argument.toJava()).await())
    }

    /**
     * @see [getEvidence].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetEvidencePlainArgs].
     * @return A class represent an AppComplianceAutomation evidence resource.
     */
    public suspend fun getEvidence(argument: suspend GetEvidencePlainArgsBuilder.() -> Unit): GetEvidenceResult {
        val builder = GetEvidencePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEvidenceResultToKotlin(getEvidencePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the count of reports.
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return The get collection count response.
     */
    public suspend fun getProviderActionCollectionCount(argument: GetProviderActionCollectionCountPlainArgs): GetProviderActionCollectionCountResult =
        getProviderActionCollectionCountResultToKotlin(getProviderActionCollectionCountPlain(argument.toJava()).await())

    /**
     * @see [getProviderActionCollectionCount].
     * @param type The resource type.
     * @return The get collection count response.
     */
    public suspend fun getProviderActionCollectionCount(type: String? = null): GetProviderActionCollectionCountResult {
        val argument = GetProviderActionCollectionCountPlainArgs(
            type = type,
        )
        return getProviderActionCollectionCountResultToKotlin(getProviderActionCollectionCountPlain(argument.toJava()).await())
    }

    /**
     * @see [getProviderActionCollectionCount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetProviderActionCollectionCountPlainArgs].
     * @return The get collection count response.
     */
    public suspend fun getProviderActionCollectionCount(argument: suspend GetProviderActionCollectionCountPlainArgsBuilder.() -> Unit): GetProviderActionCollectionCountResult {
        val builder = GetProviderActionCollectionCountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProviderActionCollectionCountResultToKotlin(getProviderActionCollectionCountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the resource overview status.
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return The get overview status response.
     */
    public suspend fun getProviderActionOverviewStatus(argument: GetProviderActionOverviewStatusPlainArgs): GetProviderActionOverviewStatusResult =
        getProviderActionOverviewStatusResultToKotlin(getProviderActionOverviewStatusPlain(argument.toJava()).await())

    /**
     * @see [getProviderActionOverviewStatus].
     * @param type The resource type.
     * @return The get overview status response.
     */
    public suspend fun getProviderActionOverviewStatus(type: String? = null): GetProviderActionOverviewStatusResult {
        val argument = GetProviderActionOverviewStatusPlainArgs(
            type = type,
        )
        return getProviderActionOverviewStatusResultToKotlin(getProviderActionOverviewStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getProviderActionOverviewStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetProviderActionOverviewStatusPlainArgs].
     * @return The get overview status response.
     */
    public suspend fun getProviderActionOverviewStatus(argument: suspend GetProviderActionOverviewStatusPlainArgsBuilder.() -> Unit): GetProviderActionOverviewStatusResult {
        val builder = GetProviderActionOverviewStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProviderActionOverviewStatusResultToKotlin(getProviderActionOverviewStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the AppComplianceAutomation report and its properties.
     * Azure REST API version: 2022-11-16-preview.
     * Other available API versions: 2024-06-27.
     * @param argument null
     * @return A class represent an AppComplianceAutomation report resource.
     */
    public suspend fun getReport(argument: GetReportPlainArgs): GetReportResult =
        getReportResultToKotlin(getReportPlain(argument.toJava()).await())

    /**
     * @see [getReport].
     * @param reportName Report Name.
     * @return A class represent an AppComplianceAutomation report resource.
     */
    public suspend fun getReport(reportName: String): GetReportResult {
        val argument = GetReportPlainArgs(
            reportName = reportName,
        )
        return getReportResultToKotlin(getReportPlain(argument.toJava()).await())
    }

    /**
     * @see [getReport].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetReportPlainArgs].
     * @return A class represent an AppComplianceAutomation report resource.
     */
    public suspend fun getReport(argument: suspend GetReportPlainArgsBuilder.() -> Unit): GetReportResult {
        val builder = GetReportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportResultToKotlin(getReportPlain(builtArgument.toJava()).await())
    }

    /**
     * Fix the AppComplianceAutomation report error. e.g: App Compliance Automation Tool service unregistered, automation removed.
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return Scoping question list.
     */
    public suspend fun getReportScopingQuestions(argument: GetReportScopingQuestionsPlainArgs): GetReportScopingQuestionsResult =
        getReportScopingQuestionsResultToKotlin(getReportScopingQuestionsPlain(argument.toJava()).await())

    /**
     * @see [getReportScopingQuestions].
     * @param reportName Report Name.
     * @return Scoping question list.
     */
    public suspend fun getReportScopingQuestions(reportName: String): GetReportScopingQuestionsResult {
        val argument = GetReportScopingQuestionsPlainArgs(
            reportName = reportName,
        )
        return getReportScopingQuestionsResultToKotlin(getReportScopingQuestionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getReportScopingQuestions].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetReportScopingQuestionsPlainArgs].
     * @return Scoping question list.
     */
    public suspend fun getReportScopingQuestions(argument: suspend GetReportScopingQuestionsPlainArgsBuilder.() -> Unit): GetReportScopingQuestionsResult {
        val builder = GetReportScopingQuestionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportScopingQuestionsResultToKotlin(getReportScopingQuestionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the AppComplianceAutomation scoping configuration of the specific report.
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return A class represent an AppComplianceAutomation scoping configuration resource.
     */
    public suspend fun getScopingConfiguration(argument: GetScopingConfigurationPlainArgs): GetScopingConfigurationResult =
        getScopingConfigurationResultToKotlin(getScopingConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getScopingConfiguration].
     * @param reportName Report Name.
     * @param scopingConfigurationName The scoping configuration of the specific report.
     * @return A class represent an AppComplianceAutomation scoping configuration resource.
     */
    public suspend fun getScopingConfiguration(reportName: String, scopingConfigurationName: String): GetScopingConfigurationResult {
        val argument = GetScopingConfigurationPlainArgs(
            reportName = reportName,
            scopingConfigurationName = scopingConfigurationName,
        )
        return getScopingConfigurationResultToKotlin(getScopingConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getScopingConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetScopingConfigurationPlainArgs].
     * @return A class represent an AppComplianceAutomation scoping configuration resource.
     */
    public suspend fun getScopingConfiguration(argument: suspend GetScopingConfigurationPlainArgsBuilder.() -> Unit): GetScopingConfigurationResult {
        val builder = GetScopingConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScopingConfigurationResultToKotlin(getScopingConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the AppComplianceAutomation webhook and its properties.
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return A class represent an AppComplianceAutomation webhook resource.
     */
    public suspend fun getWebhook(argument: GetWebhookPlainArgs): GetWebhookResult =
        getWebhookResultToKotlin(getWebhookPlain(argument.toJava()).await())

    /**
     * @see [getWebhook].
     * @param reportName Report Name.
     * @param webhookName Webhook Name.
     * @return A class represent an AppComplianceAutomation webhook resource.
     */
    public suspend fun getWebhook(reportName: String, webhookName: String): GetWebhookResult {
        val argument = GetWebhookPlainArgs(
            reportName = reportName,
            webhookName = webhookName,
        )
        return getWebhookResultToKotlin(getWebhookPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebhook].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;GetWebhookPlainArgs].
     * @return A class represent an AppComplianceAutomation webhook resource.
     */
    public suspend fun getWebhook(argument: suspend GetWebhookPlainArgsBuilder.() -> Unit): GetWebhookResult {
        val builder = GetWebhookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebhookResultToKotlin(getWebhookPlain(builtArgument.toJava()).await())
    }

    /**
     * List the storage accounts which are in use by related reports
     * Azure REST API version: 2024-06-27.
     * @param argument null
     * @return Parameters for listing in use storage accounts operation. If subscription list is null, it will check the user's all subscriptions.
     */
    public suspend fun listProviderActionInUseStorageAccounts(argument: ListProviderActionInUseStorageAccountsPlainArgs): ListProviderActionInUseStorageAccountsResult =
        listProviderActionInUseStorageAccountsResultToKotlin(listProviderActionInUseStorageAccountsPlain(argument.toJava()).await())

    /**
     * @see [listProviderActionInUseStorageAccounts].
     * @param subscriptionIds List of subscription ids to be query. If the list is null or empty, the API will query all the subscriptions of the user.
     * @return Parameters for listing in use storage accounts operation. If subscription list is null, it will check the user's all subscriptions.
     */
    public suspend fun listProviderActionInUseStorageAccounts(subscriptionIds: List<String>? = null): ListProviderActionInUseStorageAccountsResult {
        val argument = ListProviderActionInUseStorageAccountsPlainArgs(
            subscriptionIds = subscriptionIds,
        )
        return listProviderActionInUseStorageAccountsResultToKotlin(listProviderActionInUseStorageAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [listProviderActionInUseStorageAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appcomplianceautomation&#46;kotlin&#46;inputs&#46;ListProviderActionInUseStorageAccountsPlainArgs].
     * @return Parameters for listing in use storage accounts operation. If subscription list is null, it will check the user's all subscriptions.
     */
    public suspend fun listProviderActionInUseStorageAccounts(argument: suspend ListProviderActionInUseStorageAccountsPlainArgsBuilder.() -> Unit): ListProviderActionInUseStorageAccountsResult {
        val builder = ListProviderActionInUseStorageAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listProviderActionInUseStorageAccountsResultToKotlin(listProviderActionInUseStorageAccountsPlain(builtArgument.toJava()).await())
    }
}
