@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Evidence].
 */
@PulumiTagMarker
public class EvidenceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EvidenceArgs = EvidenceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EvidenceArgsBuilder.() -> Unit) {
        val builder = EvidenceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Evidence {
        val builtJavaResource =
            com.pulumi.azurenative.appcomplianceautomation.Evidence(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Evidence(builtJavaResource)
    }
}

/**
 * A class represent an AppComplianceAutomation evidence resource.
 * Azure REST API version: 2024-06-27.
 * ## Example Usage
 * ### Evidence_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var evidence = new AzureNative.AppComplianceAutomation.Evidence("evidence", new()
 *     {
 *         ControlId = "Operational_Security_10",
 *         EvidenceName = "evidence1",
 *         EvidenceType = AzureNative.AppComplianceAutomation.EvidenceType.File,
 *         FilePath = "/test-byos/evidence1.png",
 *         ReportName = "testReportName",
 *         ResponsibilityId = "authorized_ip_ranges_should_be_defined_on_kubernetes_services",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewEvidence(ctx, "evidence", &appcomplianceautomation.EvidenceArgs{
 * 			ControlId:        pulumi.String("Operational_Security_10"),
 * 			EvidenceName:     pulumi.String("evidence1"),
 * 			EvidenceType:     pulumi.String(appcomplianceautomation.EvidenceTypeFile),
 * 			FilePath:         pulumi.String("/test-byos/evidence1.png"),
 * 			ReportName:       pulumi.String("testReportName"),
 * 			ResponsibilityId: pulumi.String("authorized_ip_ranges_should_be_defined_on_kubernetes_services"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.Evidence;
 * import com.pulumi.azurenative.appcomplianceautomation.EvidenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var evidence = new Evidence("evidence", EvidenceArgs.builder()
 *             .controlId("Operational_Security_10")
 *             .evidenceName("evidence1")
 *             .evidenceType("File")
 *             .filePath("/test-byos/evidence1.png")
 *             .reportName("testReportName")
 *             .responsibilityId("authorized_ip_ranges_should_be_defined_on_kubernetes_services")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:Evidence evidence1 /providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}
 * ```
 */
public class Evidence internal constructor(
    override val javaResource: com.pulumi.azurenative.appcomplianceautomation.Evidence,
) : KotlinCustomResource(javaResource, EvidenceMapper) {
    /**
     * Control id.
     */
    public val controlId: Output<String>?
        get() = javaResource.controlId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Evidence type.
     */
    public val evidenceType: Output<String>?
        get() = javaResource.evidenceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extra data considered as evidence.
     */
    public val extraData: Output<String>?
        get() = javaResource.extraData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The path of the file in storage.
     */
    public val filePath: Output<String>
        get() = javaResource.filePath().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Responsibility id.
     */
    public val responsibilityId: Output<String>?
        get() = javaResource.responsibilityId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EvidenceMapper : ResourceMapper<Evidence> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appcomplianceautomation.Evidence::class == javaResource::class

    override fun map(javaResource: Resource): Evidence = Evidence(
        javaResource as
            com.pulumi.azurenative.appcomplianceautomation.Evidence,
    )
}

/**
 * @see [Evidence].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Evidence].
 */
public suspend fun evidence(name: String, block: suspend EvidenceResourceBuilder.() -> Unit): Evidence {
    val builder = EvidenceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Evidence].
 * @param name The _unique_ name of the resulting resource.
 */
public fun evidence(name: String): Evidence {
    val builder = EvidenceResourceBuilder()
    builder.name(name)
    return builder.build()
}
