@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.EvidenceArgs.builder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.EvidenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A class represent an AppComplianceAutomation evidence resource.
 * Azure REST API version: 2024-06-27.
 * ## Example Usage
 * ### Evidence_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var evidence = new AzureNative.AppComplianceAutomation.Evidence("evidence", new()
 *     {
 *         ControlId = "Operational_Security_10",
 *         EvidenceName = "evidence1",
 *         EvidenceType = AzureNative.AppComplianceAutomation.EvidenceType.File,
 *         FilePath = "/test-byos/evidence1.png",
 *         ReportName = "testReportName",
 *         ResponsibilityId = "authorized_ip_ranges_should_be_defined_on_kubernetes_services",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewEvidence(ctx, "evidence", &appcomplianceautomation.EvidenceArgs{
 * 			ControlId:        pulumi.String("Operational_Security_10"),
 * 			EvidenceName:     pulumi.String("evidence1"),
 * 			EvidenceType:     pulumi.String(appcomplianceautomation.EvidenceTypeFile),
 * 			FilePath:         pulumi.String("/test-byos/evidence1.png"),
 * 			ReportName:       pulumi.String("testReportName"),
 * 			ResponsibilityId: pulumi.String("authorized_ip_ranges_should_be_defined_on_kubernetes_services"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.Evidence;
 * import com.pulumi.azurenative.appcomplianceautomation.EvidenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var evidence = new Evidence("evidence", EvidenceArgs.builder()
 *             .controlId("Operational_Security_10")
 *             .evidenceName("evidence1")
 *             .evidenceType("File")
 *             .filePath("/test-byos/evidence1.png")
 *             .reportName("testReportName")
 *             .responsibilityId("authorized_ip_ranges_should_be_defined_on_kubernetes_services")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:Evidence evidence1 /providers/Microsoft.AppComplianceAutomation/reports/{reportName}/evidences/{evidenceName}
 * ```
 * @property controlId Control id.
 * @property evidenceName The evidence name.
 * @property evidenceType Evidence type.
 * @property extraData Extra data considered as evidence.
 * @property filePath The path of the file in storage.
 * @property offerGuid The offerGuid which mapping to the reports.
 * @property reportCreatorTenantId The tenant id of the report creator.
 * @property reportName Report Name.
 * @property responsibilityId Responsibility id.
 */
public data class EvidenceArgs(
    public val controlId: Output<String>? = null,
    public val evidenceName: Output<String>? = null,
    public val evidenceType: Output<Either<String, EvidenceType>>? = null,
    public val extraData: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val offerGuid: Output<String>? = null,
    public val reportCreatorTenantId: Output<String>? = null,
    public val reportName: Output<String>? = null,
    public val responsibilityId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.EvidenceArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.EvidenceArgs =
        com.pulumi.azurenative.appcomplianceautomation.EvidenceArgs.builder()
            .controlId(controlId?.applyValue({ args0 -> args0 }))
            .evidenceName(evidenceName?.applyValue({ args0 -> args0 }))
            .evidenceType(
                evidenceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extraData(extraData?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .offerGuid(offerGuid?.applyValue({ args0 -> args0 }))
            .reportCreatorTenantId(reportCreatorTenantId?.applyValue({ args0 -> args0 }))
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .responsibilityId(responsibilityId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EvidenceArgs].
 */
@PulumiTagMarker
public class EvidenceArgsBuilder internal constructor() {
    private var controlId: Output<String>? = null

    private var evidenceName: Output<String>? = null

    private var evidenceType: Output<Either<String, EvidenceType>>? = null

    private var extraData: Output<String>? = null

    private var filePath: Output<String>? = null

    private var offerGuid: Output<String>? = null

    private var reportCreatorTenantId: Output<String>? = null

    private var reportName: Output<String>? = null

    private var responsibilityId: Output<String>? = null

    /**
     * @param value Control id.
     */
    @JvmName("hcoorrjtknqqogqy")
    public suspend fun controlId(`value`: Output<String>) {
        this.controlId = value
    }

    /**
     * @param value The evidence name.
     */
    @JvmName("qvwbmtkcfsxtxidk")
    public suspend fun evidenceName(`value`: Output<String>) {
        this.evidenceName = value
    }

    /**
     * @param value Evidence type.
     */
    @JvmName("hixjbujtkyxktnwo")
    public suspend fun evidenceType(`value`: Output<Either<String, EvidenceType>>) {
        this.evidenceType = value
    }

    /**
     * @param value Extra data considered as evidence.
     */
    @JvmName("pjxrwoaixlgapnge")
    public suspend fun extraData(`value`: Output<String>) {
        this.extraData = value
    }

    /**
     * @param value The path of the file in storage.
     */
    @JvmName("svkvewbdoudkipfx")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value The offerGuid which mapping to the reports.
     */
    @JvmName("ryjantkrkdktysml")
    public suspend fun offerGuid(`value`: Output<String>) {
        this.offerGuid = value
    }

    /**
     * @param value The tenant id of the report creator.
     */
    @JvmName("ujbuktlpvtraogpg")
    public suspend fun reportCreatorTenantId(`value`: Output<String>) {
        this.reportCreatorTenantId = value
    }

    /**
     * @param value Report Name.
     */
    @JvmName("hqtwiqrgaeqgfmrc")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value Responsibility id.
     */
    @JvmName("wuhunrjuxcxikkui")
    public suspend fun responsibilityId(`value`: Output<String>) {
        this.responsibilityId = value
    }

    /**
     * @param value Control id.
     */
    @JvmName("cayyebraiqagckpr")
    public suspend fun controlId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlId = mapped
    }

    /**
     * @param value The evidence name.
     */
    @JvmName("cxiuvtspxlgjbovr")
    public suspend fun evidenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evidenceName = mapped
    }

    /**
     * @param value Evidence type.
     */
    @JvmName("mhynsnfrfkvvrjfl")
    public suspend fun evidenceType(`value`: Either<String, EvidenceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evidenceType = mapped
    }

    /**
     * @param value Evidence type.
     */
    @JvmName("lvgtsqhbnckjmypi")
    public fun evidenceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EvidenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evidenceType = mapped
    }

    /**
     * @param value Evidence type.
     */
    @JvmName("ctdlapdxxwsvdqcv")
    public fun evidenceType(`value`: EvidenceType) {
        val toBeMapped = Either.ofRight<String, EvidenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evidenceType = mapped
    }

    /**
     * @param value Extra data considered as evidence.
     */
    @JvmName("omoeqmrgyuthbqpn")
    public suspend fun extraData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraData = mapped
    }

    /**
     * @param value The path of the file in storage.
     */
    @JvmName("amnlehqhaqfqoaqi")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value The offerGuid which mapping to the reports.
     */
    @JvmName("ukatauwcschjljfg")
    public suspend fun offerGuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerGuid = mapped
    }

    /**
     * @param value The tenant id of the report creator.
     */
    @JvmName("xecbtgjftsbgbitx")
    public suspend fun reportCreatorTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportCreatorTenantId = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("cclkyldeoqwcyqsi")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value Responsibility id.
     */
    @JvmName("iwdmolbcthyfkivq")
    public suspend fun responsibilityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responsibilityId = mapped
    }

    internal fun build(): EvidenceArgs = EvidenceArgs(
        controlId = controlId,
        evidenceName = evidenceName,
        evidenceType = evidenceType,
        extraData = extraData,
        filePath = filePath,
        offerGuid = offerGuid,
        reportCreatorTenantId = reportCreatorTenantId,
        reportName = reportName,
        responsibilityId = responsibilityId,
    )
}
