@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ScopingAnswerResponse
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ScopingAnswerResponse.Companion.toKotlin as scopingAnswerResponseToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ScopingConfiguration].
 */
@PulumiTagMarker
public class ScopingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScopingConfigurationArgs = ScopingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScopingConfigurationArgsBuilder.() -> Unit) {
        val builder = ScopingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScopingConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.appcomplianceautomation.ScopingConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScopingConfiguration(builtJavaResource)
    }
}

/**
 * A class represent an AppComplianceAutomation scoping configuration resource.
 * Azure REST API version: 2024-06-27.
 * ## Example Usage
 * ### ScopingConfiguration_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopingConfiguration = new AzureNative.AppComplianceAutomation.ScopingConfiguration("scopingConfiguration", new()
 *     {
 *         Answers = new[]
 *         {
 *             new AzureNative.AppComplianceAutomation.Inputs.ScopingAnswerArgs
 *             {
 *                 Answers = new[]
 *                 {
 *                     "Azure",
 *                 },
 *                 QuestionId = "GEN20_hostingEnvironment",
 *             },
 *             new AzureNative.AppComplianceAutomation.Inputs.ScopingAnswerArgs
 *             {
 *                 Answers = new() { },
 *                 QuestionId = "DHP_G07_customerDataProcess",
 *             },
 *             new AzureNative.AppComplianceAutomation.Inputs.ScopingAnswerArgs
 *             {
 *                 Answers = new() { },
 *                 QuestionId = "Tier2InitSub_serviceCommunicate",
 *             },
 *         },
 *         ReportName = "testReportName",
 *         ScopingConfigurationName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewScopingConfiguration(ctx, "scopingConfiguration", &appcomplianceautomation.ScopingConfigurationArgs{
 * 			Answers: appcomplianceautomation.ScopingAnswerArray{
 * 				&appcomplianceautomation.ScopingAnswerArgs{
 * 					Answers: pulumi.StringArray{
 * 						pulumi.String("Azure"),
 * 					},
 * 					QuestionId: pulumi.String("GEN20_hostingEnvironment"),
 * 				},
 * 				&appcomplianceautomation.ScopingAnswerArgs{
 * 					Answers:    pulumi.StringArray{},
 * 					QuestionId: pulumi.String("DHP_G07_customerDataProcess"),
 * 				},
 * 				&appcomplianceautomation.ScopingAnswerArgs{
 * 					Answers:    pulumi.StringArray{},
 * 					QuestionId: pulumi.String("Tier2InitSub_serviceCommunicate"),
 * 				},
 * 			},
 * 			ReportName:               pulumi.String("testReportName"),
 * 			ScopingConfigurationName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.ScopingConfiguration;
 * import com.pulumi.azurenative.appcomplianceautomation.ScopingConfigurationArgs;
 * import com.pulumi.azurenative.appcomplianceautomation.inputs.ScopingAnswerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopingConfiguration = new ScopingConfiguration("scopingConfiguration", ScopingConfigurationArgs.builder()
 *             .answers(
 *                 ScopingAnswerArgs.builder()
 *                     .answers("Azure")
 *                     .questionId("GEN20_hostingEnvironment")
 *                     .build(),
 *                 ScopingAnswerArgs.builder()
 *                     .answers()
 *                     .questionId("DHP_G07_customerDataProcess")
 *                     .build(),
 *                 ScopingAnswerArgs.builder()
 *                     .answers()
 *                     .questionId("Tier2InitSub_serviceCommunicate")
 *                     .build())
 *             .reportName("testReportName")
 *             .scopingConfigurationName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:ScopingConfiguration default /providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}
 * ```
 */
public class ScopingConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.appcomplianceautomation.ScopingConfiguration,
) : KotlinCustomResource(javaResource, ScopingConfigurationMapper) {
    /**
     * List of scoping question answers.
     */
    public val answers: Output<List<ScopingAnswerResponse>>?
        get() = javaResource.answers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> scopingAnswerResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScopingConfigurationMapper : ResourceMapper<ScopingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appcomplianceautomation.ScopingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ScopingConfiguration = ScopingConfiguration(
        javaResource
            as com.pulumi.azurenative.appcomplianceautomation.ScopingConfiguration,
    )
}

/**
 * @see [ScopingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScopingConfiguration].
 */
public suspend fun scopingConfiguration(
    name: String,
    block: suspend ScopingConfigurationResourceBuilder.() -> Unit,
): ScopingConfiguration {
    val builder = ScopingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScopingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scopingConfiguration(name: String): ScopingConfiguration {
    val builder = ScopingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
