@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.ScopingConfigurationArgs.builder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.ScopingAnswerArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.ScopingAnswerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A class represent an AppComplianceAutomation scoping configuration resource.
 * Azure REST API version: 2024-06-27.
 * ## Example Usage
 * ### ScopingConfiguration_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopingConfiguration = new AzureNative.AppComplianceAutomation.ScopingConfiguration("scopingConfiguration", new()
 *     {
 *         Answers = new[]
 *         {
 *             new AzureNative.AppComplianceAutomation.Inputs.ScopingAnswerArgs
 *             {
 *                 Answers = new[]
 *                 {
 *                     "Azure",
 *                 },
 *                 QuestionId = "GEN20_hostingEnvironment",
 *             },
 *             new AzureNative.AppComplianceAutomation.Inputs.ScopingAnswerArgs
 *             {
 *                 Answers = new() { },
 *                 QuestionId = "DHP_G07_customerDataProcess",
 *             },
 *             new AzureNative.AppComplianceAutomation.Inputs.ScopingAnswerArgs
 *             {
 *                 Answers = new() { },
 *                 QuestionId = "Tier2InitSub_serviceCommunicate",
 *             },
 *         },
 *         ReportName = "testReportName",
 *         ScopingConfigurationName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewScopingConfiguration(ctx, "scopingConfiguration", &appcomplianceautomation.ScopingConfigurationArgs{
 * 			Answers: appcomplianceautomation.ScopingAnswerArray{
 * 				&appcomplianceautomation.ScopingAnswerArgs{
 * 					Answers: pulumi.StringArray{
 * 						pulumi.String("Azure"),
 * 					},
 * 					QuestionId: pulumi.String("GEN20_hostingEnvironment"),
 * 				},
 * 				&appcomplianceautomation.ScopingAnswerArgs{
 * 					Answers:    pulumi.StringArray{},
 * 					QuestionId: pulumi.String("DHP_G07_customerDataProcess"),
 * 				},
 * 				&appcomplianceautomation.ScopingAnswerArgs{
 * 					Answers:    pulumi.StringArray{},
 * 					QuestionId: pulumi.String("Tier2InitSub_serviceCommunicate"),
 * 				},
 * 			},
 * 			ReportName:               pulumi.String("testReportName"),
 * 			ScopingConfigurationName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.ScopingConfiguration;
 * import com.pulumi.azurenative.appcomplianceautomation.ScopingConfigurationArgs;
 * import com.pulumi.azurenative.appcomplianceautomation.inputs.ScopingAnswerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopingConfiguration = new ScopingConfiguration("scopingConfiguration", ScopingConfigurationArgs.builder()
 *             .answers(
 *                 ScopingAnswerArgs.builder()
 *                     .answers("Azure")
 *                     .questionId("GEN20_hostingEnvironment")
 *                     .build(),
 *                 ScopingAnswerArgs.builder()
 *                     .answers()
 *                     .questionId("DHP_G07_customerDataProcess")
 *                     .build(),
 *                 ScopingAnswerArgs.builder()
 *                     .answers()
 *                     .questionId("Tier2InitSub_serviceCommunicate")
 *                     .build())
 *             .reportName("testReportName")
 *             .scopingConfigurationName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:ScopingConfiguration default /providers/Microsoft.AppComplianceAutomation/reports/{reportName}/scopingConfigurations/{scopingConfigurationName}
 * ```
 * @property answers List of scoping question answers.
 * @property reportName Report Name.
 * @property scopingConfigurationName The scoping configuration of the specific report.
 */
public data class ScopingConfigurationArgs(
    public val answers: Output<List<ScopingAnswerArgs>>? = null,
    public val reportName: Output<String>? = null,
    public val scopingConfigurationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.ScopingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.ScopingConfigurationArgs =
        com.pulumi.azurenative.appcomplianceautomation.ScopingConfigurationArgs.builder()
            .answers(
                answers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .scopingConfigurationName(scopingConfigurationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopingConfigurationArgs].
 */
@PulumiTagMarker
public class ScopingConfigurationArgsBuilder internal constructor() {
    private var answers: Output<List<ScopingAnswerArgs>>? = null

    private var reportName: Output<String>? = null

    private var scopingConfigurationName: Output<String>? = null

    /**
     * @param value List of scoping question answers.
     */
    @JvmName("orsuolfdidognswk")
    public suspend fun answers(`value`: Output<List<ScopingAnswerArgs>>) {
        this.answers = value
    }

    @JvmName("xeypisfglenrmogk")
    public suspend fun answers(vararg values: Output<ScopingAnswerArgs>) {
        this.answers = Output.all(values.asList())
    }

    /**
     * @param values List of scoping question answers.
     */
    @JvmName("beymjumelcmtcoko")
    public suspend fun answers(values: List<Output<ScopingAnswerArgs>>) {
        this.answers = Output.all(values)
    }

    /**
     * @param value Report Name.
     */
    @JvmName("rqjjsgpsovmnbbur")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value The scoping configuration of the specific report.
     */
    @JvmName("tvojmpeemhwcoime")
    public suspend fun scopingConfigurationName(`value`: Output<String>) {
        this.scopingConfigurationName = value
    }

    /**
     * @param value List of scoping question answers.
     */
    @JvmName("moibolveeuinsgjm")
    public suspend fun answers(`value`: List<ScopingAnswerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.answers = mapped
    }

    /**
     * @param argument List of scoping question answers.
     */
    @JvmName("unwdeidwyyjcvjcj")
    public suspend fun answers(argument: List<suspend ScopingAnswerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScopingAnswerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.answers = mapped
    }

    /**
     * @param argument List of scoping question answers.
     */
    @JvmName("tdbfqeueirricmjw")
    public suspend fun answers(vararg argument: suspend ScopingAnswerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScopingAnswerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.answers = mapped
    }

    /**
     * @param argument List of scoping question answers.
     */
    @JvmName("ubynbcayrghoupgr")
    public suspend fun answers(argument: suspend ScopingAnswerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScopingAnswerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.answers = mapped
    }

    /**
     * @param values List of scoping question answers.
     */
    @JvmName("popagvgtbvfpetcy")
    public suspend fun answers(vararg values: ScopingAnswerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.answers = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("ujcvattfanymrjdv")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value The scoping configuration of the specific report.
     */
    @JvmName("lqqdxbaxffvkateo")
    public suspend fun scopingConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopingConfigurationName = mapped
    }

    internal fun build(): ScopingConfigurationArgs = ScopingConfigurationArgs(
        answers = answers,
        reportName = reportName,
        scopingConfigurationName = scopingConfigurationName,
    )
}
