@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Webhook].
 */
@PulumiTagMarker
public class WebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebhookArgs = WebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebhookArgsBuilder.() -> Unit) {
        val builder = WebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Webhook {
        val builtJavaResource =
            com.pulumi.azurenative.appcomplianceautomation.Webhook(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Webhook(builtJavaResource)
    }
}

/**
 * A class represent an AppComplianceAutomation webhook resource.
 * Azure REST API version: 2024-06-27.
 * ## Example Usage
 * ### Webhook_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webhook = new AzureNative.AppComplianceAutomation.Webhook("webhook", new()
 *     {
 *         ContentType = AzureNative.AppComplianceAutomation.ContentType.ApplicationJson,
 *         EnableSslVerification = AzureNative.AppComplianceAutomation.EnableSslVerification.True,
 *         Events = new[]
 *         {
 *             AzureNative.AppComplianceAutomation.NotificationEvent.Generate_snapshot_failed,
 *         },
 *         PayloadUrl = "https://example.com",
 *         ReportName = "testReportName",
 *         SendAllEvents = AzureNative.AppComplianceAutomation.SendAllEvents.False,
 *         Status = AzureNative.AppComplianceAutomation.WebhookStatus.Enabled,
 *         UpdateWebhookKey = AzureNative.AppComplianceAutomation.UpdateWebhookKey.True,
 *         WebhookKey = "00000000-0000-0000-0000-000000000000",
 *         WebhookName = "testWebhookName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewWebhook(ctx, "webhook", &appcomplianceautomation.WebhookArgs{
 * 			ContentType:           pulumi.String(appcomplianceautomation.ContentTypeApplicationJson),
 * 			EnableSslVerification: pulumi.String(appcomplianceautomation.EnableSslVerificationTrue),
 * 			Events: pulumi.StringArray{
 * 				pulumi.String(appcomplianceautomation.NotificationEvent_Generate_snapshot_failed),
 * 			},
 * 			PayloadUrl:       pulumi.String("https://example.com"),
 * 			ReportName:       pulumi.String("testReportName"),
 * 			SendAllEvents:    pulumi.String(appcomplianceautomation.SendAllEventsFalse),
 * 			Status:           pulumi.String(appcomplianceautomation.WebhookStatusEnabled),
 * 			UpdateWebhookKey: pulumi.String(appcomplianceautomation.UpdateWebhookKeyTrue),
 * 			WebhookKey:       pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			WebhookName:      pulumi.String("testWebhookName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.Webhook;
 * import com.pulumi.azurenative.appcomplianceautomation.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webhook = new Webhook("webhook", WebhookArgs.builder()
 *             .contentType("application/json")
 *             .enableSslVerification("true")
 *             .events("generate_snapshot_failed")
 *             .payloadUrl("https://example.com")
 *             .reportName("testReportName")
 *             .sendAllEvents("false")
 *             .status("Enabled")
 *             .updateWebhookKey("true")
 *             .webhookKey("00000000-0000-0000-0000-000000000000")
 *             .webhookName("testWebhookName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:Webhook testWebhookName /providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}
 * ```
 */
public class Webhook internal constructor(
    override val javaResource: com.pulumi.azurenative.appcomplianceautomation.Webhook,
) : KotlinCustomResource(javaResource, WebhookMapper) {
    /**
     * content type
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * webhook deliveryStatus
     */
    public val deliveryStatus: Output<String>
        get() = javaResource.deliveryStatus().applyValue({ args0 -> args0 })

    /**
     * whether to enable ssl verification
     */
    public val enableSslVerification: Output<String>?
        get() = javaResource.enableSslVerification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * under which event notification should be sent.
     */
    public val events: Output<List<String>>?
        get() = javaResource.events().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * webhook payload url
     */
    public val payloadUrl: Output<String>?
        get() = javaResource.payloadUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Provisioning State
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * whether to send notification under any event.
     */
    public val sendAllEvents: Output<String>?
        get() = javaResource.sendAllEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Webhook status.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tenant id.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * whether to update webhookKey.
     */
    public val updateWebhookKey: Output<String>?
        get() = javaResource.updateWebhookKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Webhook id in database.
     */
    public val webhookId: Output<String>
        get() = javaResource.webhookId().applyValue({ args0 -> args0 })

    /**
     * webhook secret token. If not set, this field value is null; otherwise, please set a string value.
     */
    public val webhookKey: Output<String>?
        get() = javaResource.webhookKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * whether webhookKey is enabled.
     */
    public val webhookKeyEnabled: Output<String>
        get() = javaResource.webhookKeyEnabled().applyValue({ args0 -> args0 })
}

public object WebhookMapper : ResourceMapper<Webhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appcomplianceautomation.Webhook::class == javaResource::class

    override fun map(javaResource: Resource): Webhook = Webhook(
        javaResource as
            com.pulumi.azurenative.appcomplianceautomation.Webhook,
    )
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Webhook].
 */
public suspend fun webhook(name: String, block: suspend WebhookResourceBuilder.() -> Unit): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webhook(name: String): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
