@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.WebhookArgs.builder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.ContentType
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.EnableSslVerification
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.NotificationEvent
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.SendAllEvents
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.UpdateWebhookKey
import com.pulumi.azurenative.appcomplianceautomation.kotlin.enums.WebhookStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A class represent an AppComplianceAutomation webhook resource.
 * Azure REST API version: 2024-06-27.
 * ## Example Usage
 * ### Webhook_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webhook = new AzureNative.AppComplianceAutomation.Webhook("webhook", new()
 *     {
 *         ContentType = AzureNative.AppComplianceAutomation.ContentType.ApplicationJson,
 *         EnableSslVerification = AzureNative.AppComplianceAutomation.EnableSslVerification.True,
 *         Events = new[]
 *         {
 *             AzureNative.AppComplianceAutomation.NotificationEvent.Generate_snapshot_failed,
 *         },
 *         PayloadUrl = "https://example.com",
 *         ReportName = "testReportName",
 *         SendAllEvents = AzureNative.AppComplianceAutomation.SendAllEvents.False,
 *         Status = AzureNative.AppComplianceAutomation.WebhookStatus.Enabled,
 *         UpdateWebhookKey = AzureNative.AppComplianceAutomation.UpdateWebhookKey.True,
 *         WebhookKey = "00000000-0000-0000-0000-000000000000",
 *         WebhookName = "testWebhookName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewWebhook(ctx, "webhook", &appcomplianceautomation.WebhookArgs{
 * 			ContentType:           pulumi.String(appcomplianceautomation.ContentTypeApplicationJson),
 * 			EnableSslVerification: pulumi.String(appcomplianceautomation.EnableSslVerificationTrue),
 * 			Events: pulumi.StringArray{
 * 				pulumi.String(appcomplianceautomation.NotificationEvent_Generate_snapshot_failed),
 * 			},
 * 			PayloadUrl:       pulumi.String("https://example.com"),
 * 			ReportName:       pulumi.String("testReportName"),
 * 			SendAllEvents:    pulumi.String(appcomplianceautomation.SendAllEventsFalse),
 * 			Status:           pulumi.String(appcomplianceautomation.WebhookStatusEnabled),
 * 			UpdateWebhookKey: pulumi.String(appcomplianceautomation.UpdateWebhookKeyTrue),
 * 			WebhookKey:       pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			WebhookName:      pulumi.String("testWebhookName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.Webhook;
 * import com.pulumi.azurenative.appcomplianceautomation.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webhook = new Webhook("webhook", WebhookArgs.builder()
 *             .contentType("application/json")
 *             .enableSslVerification("true")
 *             .events("generate_snapshot_failed")
 *             .payloadUrl("https://example.com")
 *             .reportName("testReportName")
 *             .sendAllEvents("false")
 *             .status("Enabled")
 *             .updateWebhookKey("true")
 *             .webhookKey("00000000-0000-0000-0000-000000000000")
 *             .webhookName("testWebhookName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:Webhook testWebhookName /providers/Microsoft.AppComplianceAutomation/reports/{reportName}/webhooks/{webhookName}
 * ```
 * @property contentType content type
 * @property enableSslVerification whether to enable ssl verification
 * @property events under which event notification should be sent.
 * @property payloadUrl webhook payload url
 * @property reportName Report Name.
 * @property sendAllEvents whether to send notification under any event.
 * @property status Webhook status.
 * @property updateWebhookKey whether to update webhookKey.
 * @property webhookKey webhook secret token. If not set, this field value is null; otherwise, please set a string value.
 * @property webhookName Webhook Name.
 */
public data class WebhookArgs(
    public val contentType: Output<Either<String, ContentType>>? = null,
    public val enableSslVerification: Output<Either<String, EnableSslVerification>>? = null,
    public val events: Output<List<Either<String, NotificationEvent>>>? = null,
    public val payloadUrl: Output<String>? = null,
    public val reportName: Output<String>? = null,
    public val sendAllEvents: Output<Either<String, SendAllEvents>>? = null,
    public val status: Output<Either<String, WebhookStatus>>? = null,
    public val updateWebhookKey: Output<Either<String, UpdateWebhookKey>>? = null,
    public val webhookKey: Output<String>? = null,
    public val webhookName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.WebhookArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.WebhookArgs =
        com.pulumi.azurenative.appcomplianceautomation.WebhookArgs.builder()
            .contentType(
                contentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableSslVerification(
                enableSslVerification?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .events(
                events?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .payloadUrl(payloadUrl?.applyValue({ args0 -> args0 }))
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .sendAllEvents(
                sendAllEvents?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .updateWebhookKey(
                updateWebhookKey?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .webhookKey(webhookKey?.applyValue({ args0 -> args0 }))
            .webhookName(webhookName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var contentType: Output<Either<String, ContentType>>? = null

    private var enableSslVerification: Output<Either<String, EnableSslVerification>>? = null

    private var events: Output<List<Either<String, NotificationEvent>>>? = null

    private var payloadUrl: Output<String>? = null

    private var reportName: Output<String>? = null

    private var sendAllEvents: Output<Either<String, SendAllEvents>>? = null

    private var status: Output<Either<String, WebhookStatus>>? = null

    private var updateWebhookKey: Output<Either<String, UpdateWebhookKey>>? = null

    private var webhookKey: Output<String>? = null

    private var webhookName: Output<String>? = null

    /**
     * @param value content type
     */
    @JvmName("ttyqybxceitxttsd")
    public suspend fun contentType(`value`: Output<Either<String, ContentType>>) {
        this.contentType = value
    }

    /**
     * @param value whether to enable ssl verification
     */
    @JvmName("nnjyjspbrdxlwpyp")
    public suspend fun enableSslVerification(`value`: Output<Either<String, EnableSslVerification>>) {
        this.enableSslVerification = value
    }

    /**
     * @param value under which event notification should be sent.
     */
    @JvmName("ltpgdypexgifedrc")
    public suspend fun events(`value`: Output<List<Either<String, NotificationEvent>>>) {
        this.events = value
    }

    @JvmName("ulruoipoduqbfggr")
    public suspend fun events(vararg values: Output<Either<String, NotificationEvent>>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values under which event notification should be sent.
     */
    @JvmName("jweehehvlqsppbdy")
    public suspend fun events(values: List<Output<Either<String, NotificationEvent>>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value webhook payload url
     */
    @JvmName("kpldnqarfvptephw")
    public suspend fun payloadUrl(`value`: Output<String>) {
        this.payloadUrl = value
    }

    /**
     * @param value Report Name.
     */
    @JvmName("ufvmifsyefirfsvj")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value whether to send notification under any event.
     */
    @JvmName("brghtywejqoxpncn")
    public suspend fun sendAllEvents(`value`: Output<Either<String, SendAllEvents>>) {
        this.sendAllEvents = value
    }

    /**
     * @param value Webhook status.
     */
    @JvmName("aiswccdyrnwmkoni")
    public suspend fun status(`value`: Output<Either<String, WebhookStatus>>) {
        this.status = value
    }

    /**
     * @param value whether to update webhookKey.
     */
    @JvmName("penvwkxqhyoxigfm")
    public suspend fun updateWebhookKey(`value`: Output<Either<String, UpdateWebhookKey>>) {
        this.updateWebhookKey = value
    }

    /**
     * @param value webhook secret token. If not set, this field value is null; otherwise, please set a string value.
     */
    @JvmName("clyfkmaxcbuxwagh")
    public suspend fun webhookKey(`value`: Output<String>) {
        this.webhookKey = value
    }

    /**
     * @param value Webhook Name.
     */
    @JvmName("eugjnkhglpjygcto")
    public suspend fun webhookName(`value`: Output<String>) {
        this.webhookName = value
    }

    /**
     * @param value content type
     */
    @JvmName("uklidchegujdqcrd")
    public suspend fun contentType(`value`: Either<String, ContentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value content type
     */
    @JvmName("ptyrvfakloqokcog")
    public fun contentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value content type
     */
    @JvmName("qbnvepcvcsewtfbq")
    public fun contentType(`value`: ContentType) {
        val toBeMapped = Either.ofRight<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value whether to enable ssl verification
     */
    @JvmName("duqlsyouupslifyp")
    public suspend fun enableSslVerification(`value`: Either<String, EnableSslVerification>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value whether to enable ssl verification
     */
    @JvmName("emqbaebioiamxnap")
    public fun enableSslVerification(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableSslVerification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value whether to enable ssl verification
     */
    @JvmName("chjtepthwepgfoqr")
    public fun enableSslVerification(`value`: EnableSslVerification) {
        val toBeMapped = Either.ofRight<String, EnableSslVerification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value under which event notification should be sent.
     */
    @JvmName("vlmowleovpsglaqm")
    public suspend fun events(`value`: List<Either<String, NotificationEvent>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values under which event notification should be sent.
     */
    @JvmName("ioyeyvmrsocvvfbg")
    public suspend fun events(vararg values: Either<String, NotificationEvent>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value webhook payload url
     */
    @JvmName("whcgphhlrnjdqeyb")
    public suspend fun payloadUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadUrl = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("ygalcwubkgjqfcot")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value whether to send notification under any event.
     */
    @JvmName("frjtofoqrdlhktob")
    public suspend fun sendAllEvents(`value`: Either<String, SendAllEvents>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendAllEvents = mapped
    }

    /**
     * @param value whether to send notification under any event.
     */
    @JvmName("dtjwbamxjabgoqet")
    public fun sendAllEvents(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SendAllEvents>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendAllEvents = mapped
    }

    /**
     * @param value whether to send notification under any event.
     */
    @JvmName("hvhtgodwdahnpisy")
    public fun sendAllEvents(`value`: SendAllEvents) {
        val toBeMapped = Either.ofRight<String, SendAllEvents>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendAllEvents = mapped
    }

    /**
     * @param value Webhook status.
     */
    @JvmName("baqtnmegovvtvnun")
    public suspend fun status(`value`: Either<String, WebhookStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Webhook status.
     */
    @JvmName("eusuwredgfbwxsuh")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebhookStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Webhook status.
     */
    @JvmName("tsotcriqdwpabttj")
    public fun status(`value`: WebhookStatus) {
        val toBeMapped = Either.ofRight<String, WebhookStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value whether to update webhookKey.
     */
    @JvmName("ghdsfefvibrknjvw")
    public suspend fun updateWebhookKey(`value`: Either<String, UpdateWebhookKey>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateWebhookKey = mapped
    }

    /**
     * @param value whether to update webhookKey.
     */
    @JvmName("jxkvhfiqsxsiilxv")
    public fun updateWebhookKey(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpdateWebhookKey>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updateWebhookKey = mapped
    }

    /**
     * @param value whether to update webhookKey.
     */
    @JvmName("snvdfnhjhvonemuu")
    public fun updateWebhookKey(`value`: UpdateWebhookKey) {
        val toBeMapped = Either.ofRight<String, UpdateWebhookKey>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updateWebhookKey = mapped
    }

    /**
     * @param value webhook secret token. If not set, this field value is null; otherwise, please set a string value.
     */
    @JvmName("elealwlxvifbdhqf")
    public suspend fun webhookKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookKey = mapped
    }

    /**
     * @param value Webhook Name.
     */
    @JvmName("sokywvgqnmvxrmvk")
    public suspend fun webhookName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookName = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        contentType = contentType,
        enableSslVerification = enableSslVerification,
        events = events,
        payloadUrl = payloadUrl,
        reportName = reportName,
        sendAllEvents = sendAllEvents,
        status = status,
        updateWebhookKey = updateWebhookKey,
        webhookKey = webhookKey,
        webhookName = webhookName,
    )
}
