@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Evidence type.
 */
public enum class EvidenceType(
    public val javaValue: com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType> {
    /**
     * The evidence is a file.
     */
    File(com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType.File),

    /**
     * The evidence auto collected by App Compliance Automation.
     */
    AutoCollectedEvidence(com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType.AutoCollectedEvidence),

    /**
     * The evidence is data.
     */
    Data(com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType.Data),
    ;

    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.enums.EvidenceType): EvidenceType = EvidenceType.values().first { it.javaValue == javaType }
    }
}
