@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * notification event.
 */
public enum class NotificationEvent(
    public val javaValue: com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent> {
    /**
     * The subscribed report's snapshot is successfully generated.
     */
    Generate_snapshot_success(com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent.Generate_snapshot_success),

    /**
     * The subscribed report's snapshot is failed to generate.
     */
    Generate_snapshot_failed(com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent.Generate_snapshot_failed),

    /**
     * The subscribed report failed while collecting the assessments.
     */
    Assessment_failure(com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent.Assessment_failure),

    /**
     * The subscribed report's configuration is changed.
     */
    Report_configuration_changes(com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent.Report_configuration_changes),

    /**
     * The subscribed report is deleted.
     */
    Report_deletion(com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent.Report_deletion),
    ;

    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.enums.NotificationEvent): NotificationEvent = NotificationEvent.values().first { it.javaValue == javaType }
    }
}
