@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * whether to send notification under any event.
 */
public enum class SendAllEvents(
    public val javaValue: com.pulumi.azurenative.appcomplianceautomation.enums.SendAllEvents,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.enums.SendAllEvents> {
    /**
     * Need send notification under any event.
     */
    True(com.pulumi.azurenative.appcomplianceautomation.enums.SendAllEvents.True),

    /**
     * No need to send notification under any event.
     */
    False(com.pulumi.azurenative.appcomplianceautomation.enums.SendAllEvents.False),
    ;

    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.enums.SendAllEvents =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.enums.SendAllEvents): SendAllEvents = SendAllEvents.values().first { it.javaValue == javaType }
    }
}
