@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Webhook status.
 */
public enum class WebhookStatus(
    public val javaValue: com.pulumi.azurenative.appcomplianceautomation.enums.WebhookStatus,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.enums.WebhookStatus> {
    /**
     * The webhook is enabled.
     */
    Enabled(com.pulumi.azurenative.appcomplianceautomation.enums.WebhookStatus.Enabled),

    /**
     * The webhook is disabled.
     */
    Disabled(com.pulumi.azurenative.appcomplianceautomation.enums.WebhookStatus.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.enums.WebhookStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.enums.WebhookStatus): WebhookStatus = WebhookStatus.values().first { it.javaValue == javaType }
    }
}
