@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.GetEvidencePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property evidenceName The evidence name.
 * @property reportName Report Name.
 */
public data class GetEvidencePlainArgs(
    public val evidenceName: String,
    public val reportName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.GetEvidencePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.GetEvidencePlainArgs = com.pulumi.azurenative.appcomplianceautomation.inputs.GetEvidencePlainArgs.builder()
        .evidenceName(evidenceName.let({ args0 -> args0 }))
        .reportName(reportName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEvidencePlainArgs].
 */
@PulumiTagMarker
public class GetEvidencePlainArgsBuilder internal constructor() {
    private var evidenceName: String? = null

    private var reportName: String? = null

    /**
     * @param value The evidence name.
     */
    @JvmName("knjbeenwemjvjmok")
    public suspend fun evidenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.evidenceName = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("aongyydbfhmpgsbl")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    internal fun build(): GetEvidencePlainArgs = GetEvidencePlainArgs(
        evidenceName = evidenceName ?: throw PulumiNullFieldException("evidenceName"),
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
    )
}
