@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.GetScopingConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property reportName Report Name.
 * @property scopingConfigurationName The scoping configuration of the specific report.
 */
public data class GetScopingConfigurationPlainArgs(
    public val reportName: String,
    public val scopingConfigurationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.GetScopingConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.GetScopingConfigurationPlainArgs =
        com.pulumi.azurenative.appcomplianceautomation.inputs.GetScopingConfigurationPlainArgs.builder()
            .reportName(reportName.let({ args0 -> args0 }))
            .scopingConfigurationName(scopingConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScopingConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetScopingConfigurationPlainArgsBuilder internal constructor() {
    private var reportName: String? = null

    private var scopingConfigurationName: String? = null

    /**
     * @param value Report Name.
     */
    @JvmName("jvfhlivnpicaeorn")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    /**
     * @param value The scoping configuration of the specific report.
     */
    @JvmName("suhvfyxfpugcvorg")
    public suspend fun scopingConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopingConfigurationName = mapped
    }

    internal fun build(): GetScopingConfigurationPlainArgs = GetScopingConfigurationPlainArgs(
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
        scopingConfigurationName = scopingConfigurationName ?: throw
            PulumiNullFieldException("scopingConfigurationName"),
    )
}
