@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.GetWebhookPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property reportName Report Name.
 * @property webhookName Webhook Name.
 */
public data class GetWebhookPlainArgs(
    public val reportName: String,
    public val webhookName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.GetWebhookPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.GetWebhookPlainArgs =
        com.pulumi.azurenative.appcomplianceautomation.inputs.GetWebhookPlainArgs.builder()
            .reportName(reportName.let({ args0 -> args0 }))
            .webhookName(webhookName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebhookPlainArgs].
 */
@PulumiTagMarker
public class GetWebhookPlainArgsBuilder internal constructor() {
    private var reportName: String? = null

    private var webhookName: String? = null

    /**
     * @param value Report Name.
     */
    @JvmName("nuyinrxaaoiefwfi")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    /**
     * @param value Webhook Name.
     */
    @JvmName("xsbecplwlqvbowbo")
    public suspend fun webhookName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webhookName = mapped
    }

    internal fun build(): GetWebhookPlainArgs = GetWebhookPlainArgs(
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
        webhookName = webhookName ?: throw PulumiNullFieldException("webhookName"),
    )
}
