@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.ListProviderActionInUseStorageAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property subscriptionIds List of subscription ids to be query. If the list is null or empty, the API will query all the subscriptions of the user.
 */
public data class ListProviderActionInUseStorageAccountsPlainArgs(
    public val subscriptionIds: List<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.ListProviderActionInUseStorageAccountsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.ListProviderActionInUseStorageAccountsPlainArgs =
        com.pulumi.azurenative.appcomplianceautomation.inputs.ListProviderActionInUseStorageAccountsPlainArgs.builder()
            .subscriptionIds(subscriptionIds?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListProviderActionInUseStorageAccountsPlainArgs].
 */
@PulumiTagMarker
public class ListProviderActionInUseStorageAccountsPlainArgsBuilder internal constructor() {
    private var subscriptionIds: List<String>? = null

    /**
     * @param value List of subscription ids to be query. If the list is null or empty, the API will query all the subscriptions of the user.
     */
    @JvmName("bynniiiiprjbilsb")
    public suspend fun subscriptionIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionIds = mapped
    }

    /**
     * @param values List of subscription ids to be query. If the list is null or empty, the API will query all the subscriptions of the user.
     */
    @JvmName("ywypbsjomrtbrsqy")
    public suspend fun subscriptionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subscriptionIds = mapped
    }

    internal fun build(): ListProviderActionInUseStorageAccountsPlainArgs =
        ListProviderActionInUseStorageAccountsPlainArgs(
            subscriptionIds = subscriptionIds,
        )
}
