@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs

import com.pulumi.azurenative.appcomplianceautomation.inputs.ScopingAnswerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Scoping answer.
 * @property answers Question answer value list.
 * @property questionId Question id.
 */
public data class ScopingAnswerArgs(
    public val answers: Output<List<String>>,
    public val questionId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.inputs.ScopingAnswerArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.inputs.ScopingAnswerArgs =
        com.pulumi.azurenative.appcomplianceautomation.inputs.ScopingAnswerArgs.builder()
            .answers(answers.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .questionId(questionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopingAnswerArgs].
 */
@PulumiTagMarker
public class ScopingAnswerArgsBuilder internal constructor() {
    private var answers: Output<List<String>>? = null

    private var questionId: Output<String>? = null

    /**
     * @param value Question answer value list.
     */
    @JvmName("fqwrgsbpmhhkmlyj")
    public suspend fun answers(`value`: Output<List<String>>) {
        this.answers = value
    }

    @JvmName("bpewsuagwdftogms")
    public suspend fun answers(vararg values: Output<String>) {
        this.answers = Output.all(values.asList())
    }

    /**
     * @param values Question answer value list.
     */
    @JvmName("dwtlkeljyloraijw")
    public suspend fun answers(values: List<Output<String>>) {
        this.answers = Output.all(values)
    }

    /**
     * @param value Question id.
     */
    @JvmName("lakcwfenutuherjn")
    public suspend fun questionId(`value`: Output<String>) {
        this.questionId = value
    }

    /**
     * @param value Question answer value list.
     */
    @JvmName("pyqqtktoyeiebgch")
    public suspend fun answers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.answers = mapped
    }

    /**
     * @param values Question answer value list.
     */
    @JvmName("wkhdblqrevdinijc")
    public suspend fun answers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.answers = mapped
    }

    /**
     * @param value Question id.
     */
    @JvmName("wmyhdybudritfneq")
    public suspend fun questionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.questionId = mapped
    }

    internal fun build(): ScopingAnswerArgs = ScopingAnswerArgs(
        answers = answers ?: throw PulumiNullFieldException("answers"),
        questionId = questionId ?: throw PulumiNullFieldException("questionId"),
    )
}
