@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class represent an AppComplianceAutomation evidence resource.
 * @property controlId Control id.
 * @property evidenceType Evidence type.
 * @property extraData Extra data considered as evidence.
 * @property filePath The path of the file in storage.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Azure lifecycle management
 * @property responsibilityId Responsibility id.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEvidenceResult(
    public val controlId: String? = null,
    public val evidenceType: String? = null,
    public val extraData: String? = null,
    public val filePath: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val responsibilityId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.GetEvidenceResult): GetEvidenceResult = GetEvidenceResult(
            controlId = javaType.controlId().map({ args0 -> args0 }).orElse(null),
            evidenceType = javaType.evidenceType().map({ args0 -> args0 }).orElse(null),
            extraData = javaType.extraData().map({ args0 -> args0 }).orElse(null),
            filePath = javaType.filePath(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            responsibilityId = javaType.responsibilityId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
