@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A class represent an AppComplianceAutomation webhook resource.
 * @property contentType content type
 * @property deliveryStatus webhook deliveryStatus
 * @property enableSslVerification whether to enable ssl verification
 * @property events under which event notification should be sent.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property payloadUrl webhook payload url
 * @property provisioningState Azure Resource Provisioning State
 * @property sendAllEvents whether to send notification under any event.
 * @property status Webhook status.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tenantId Tenant id.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updateWebhookKey whether to update webhookKey.
 * @property webhookId Webhook id in database.
 * @property webhookKey webhook secret token. If not set, this field value is null; otherwise, please set a string value.
 * @property webhookKeyEnabled whether webhookKey is enabled.
 */
public data class GetWebhookResult(
    public val contentType: String? = null,
    public val deliveryStatus: String,
    public val enableSslVerification: String? = null,
    public val events: List<String>? = null,
    public val id: String,
    public val name: String,
    public val payloadUrl: String? = null,
    public val provisioningState: String,
    public val sendAllEvents: String? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val tenantId: String,
    public val type: String,
    public val updateWebhookKey: String? = null,
    public val webhookId: String,
    public val webhookKey: String? = null,
    public val webhookKeyEnabled: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.GetWebhookResult): GetWebhookResult = GetWebhookResult(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            deliveryStatus = javaType.deliveryStatus(),
            enableSslVerification = javaType.enableSslVerification().map({ args0 -> args0 }).orElse(null),
            events = javaType.events().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            payloadUrl = javaType.payloadUrl().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sendAllEvents = javaType.sendAllEvents().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            updateWebhookKey = javaType.updateWebhookKey().map({ args0 -> args0 }).orElse(null),
            webhookId = javaType.webhookId(),
            webhookKey = javaType.webhookKey().map({ args0 -> args0 }).orElse(null),
            webhookKeyEnabled = javaType.webhookKeyEnabled(),
        )
    }
}
