@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters for listing in use storage accounts operation. If subscription list is null, it will check the user's all subscriptions.
 * @property storageAccountList The storage account list which in use in related reports.
 */
public data class ListProviderActionInUseStorageAccountsResult(
    public val storageAccountList: List<StorageInfoResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.ListProviderActionInUseStorageAccountsResult): ListProviderActionInUseStorageAccountsResult = ListProviderActionInUseStorageAccountsResult(
            storageAccountList = javaType.storageAccountList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.StorageInfoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
