@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Report's properties.
 * @property complianceStatus Report compliance status.
 * @property id Report id in database.
 * @property lastTriggerTime Report last collection trigger time.
 * @property nextTriggerTime Report next collection trigger time.
 * @property offerGuid Report offer Guid.
 * @property provisioningState Azure lifecycle management
 * @property reportName Report name.
 * @property resources List of resource data.
 * @property status Report status.
 * @property subscriptions List of subscription Ids.
 * @property tenantId Report's tenant id.
 * @property timeZone Report collection trigger time's time zone, the available list can be obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
 * An example of valid timezone id is "Pacific Standard Time".
 * @property triggerTime Report collection trigger time.
 */
public data class ReportPropertiesResponse(
    public val complianceStatus: ReportComplianceStatusResponse,
    public val id: String,
    public val lastTriggerTime: String,
    public val nextTriggerTime: String,
    public val offerGuid: String? = null,
    public val provisioningState: String,
    public val reportName: String,
    public val resources: List<ResourceMetadataResponse>,
    public val status: String,
    public val subscriptions: List<String>,
    public val tenantId: String,
    public val timeZone: String,
    public val triggerTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.ReportPropertiesResponse): ReportPropertiesResponse = ReportPropertiesResponse(
            complianceStatus = javaType.complianceStatus().let({ args0 ->
                com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ReportComplianceStatusResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            lastTriggerTime = javaType.lastTriggerTime(),
            nextTriggerTime = javaType.nextTriggerTime(),
            offerGuid = javaType.offerGuid().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            reportName = javaType.reportName(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ResourceMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            subscriptions = javaType.subscriptions().map({ args0 -> args0 }),
            tenantId = javaType.tenantId(),
            timeZone = javaType.timeZone(),
            triggerTime = javaType.triggerTime(),
        )
    }
}
