@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Single resource Id's metadata.
 * @property resourceId Resource Id - e.g. "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
 * @property resourceKind Resource kind.
 * @property resourceName Resource name.
 * @property resourceType Resource type.
 * @property tags Resource's tag type.
 */
public data class ResourceMetadataResponse(
    public val resourceId: String,
    public val resourceKind: String? = null,
    public val resourceName: String? = null,
    public val resourceType: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.ResourceMetadataResponse): ResourceMetadataResponse = ResourceMetadataResponse(
            resourceId = javaType.resourceId(),
            resourceKind = javaType.resourceKind().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
