@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Scoping answer.
 * @property answers Question answer value list.
 * @property questionId Question id.
 */
public data class ScopingAnswerResponse(
    public val answers: List<String>,
    public val questionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.ScopingAnswerResponse): ScopingAnswerResponse = ScopingAnswerResponse(
            answers = javaType.answers().map({ args0 -> args0 }),
            questionId = javaType.questionId(),
        )
    }
}
