@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The definition of a scoping question.
 * @property inputType Input type of the question answer.
 * @property optionIds Option id list.
 * @property questionId Question id.
 * @property rules The rule of the question.
 * @property showSubQuestionsValue The answer value to show the sub questions.
 * @property superiorQuestionId Superior question id.
 */
public data class ScopingQuestionResponse(
    public val inputType: String,
    public val optionIds: List<String>,
    public val questionId: String,
    public val rules: List<String>,
    public val showSubQuestionsValue: String,
    public val superiorQuestionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.ScopingQuestionResponse): ScopingQuestionResponse = ScopingQuestionResponse(
            inputType = javaType.inputType(),
            optionIds = javaType.optionIds().map({ args0 -> args0 }),
            questionId = javaType.questionId(),
            rules = javaType.rules().map({ args0 -> args0 }),
            showSubQuestionsValue = javaType.showSubQuestionsValue(),
            superiorQuestionId = javaType.superiorQuestionId(),
        )
    }
}
