@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Single status.
 * @property statusName Status name - e.g. "Active", "Failed".
 * @property statusValue Status value. e.g. "100", or "100%".
 */
public data class StatusItemResponse(
    public val statusName: String? = null,
    public val statusValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.StatusItemResponse): StatusItemResponse = StatusItemResponse(
            statusName = javaType.statusName().map({ args0 -> args0 }).orElse(null),
            statusValue = javaType.statusValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
