@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The information of 'bring your own storage' account binding to the report
 * @property accountName 'bring your own storage' account name
 * @property location The region of 'bring your own storage' account
 * @property resourceGroup The resourceGroup which 'bring your own storage' account belongs to
 * @property subscriptionId The subscription id which 'bring your own storage' account belongs to
 */
public data class StorageInfoResponse(
    public val accountName: String? = null,
    public val location: String? = null,
    public val resourceGroup: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.StorageInfoResponse): StorageInfoResponse = StorageInfoResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
