@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin

import com.pulumi.azurenative.appconfiguration.ReplicaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The replica resource.
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2023-08-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### Replicas_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replica = new AzureNative.AppConfiguration.Replica("replica", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         Location = "eastus",
 *         ReplicaName = "myReplicaEus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewReplica(ctx, "replica", &appconfiguration.ReplicaArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			Location:          pulumi.String("eastus"),
 * 			ReplicaName:       pulumi.String("myReplicaEus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.Replica;
 * import com.pulumi.azurenative.appconfiguration.ReplicaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replica = new Replica("replica", ReplicaArgs.builder()
 *             .configStoreName("contoso")
 *             .location("eastus")
 *             .replicaName("myReplicaEus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appconfiguration:Replica myReplicaEus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/replicas/{replicaName}
 * ```
 * @property configStoreName The name of the configuration store.
 * @property location The location of the replica.
 * @property replicaName The name of the replica.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 */
public data class ReplicaArgs(
    public val configStoreName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val replicaName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.ReplicaArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.ReplicaArgs =
        com.pulumi.azurenative.appconfiguration.ReplicaArgs.builder()
            .configStoreName(configStoreName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .replicaName(replicaName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicaArgs].
 */
@PulumiTagMarker
public class ReplicaArgsBuilder internal constructor() {
    private var configStoreName: Output<String>? = null

    private var location: Output<String>? = null

    private var replicaName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("dpxqquqpjeambmvb")
    public suspend fun configStoreName(`value`: Output<String>) {
        this.configStoreName = value
    }

    /**
     * @param value The location of the replica.
     */
    @JvmName("kvkjfmpoqbvamixt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the replica.
     */
    @JvmName("jvuvfmhanrggtret")
    public suspend fun replicaName(`value`: Output<String>) {
        this.replicaName = value
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("ukuisiarbblasndy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("xfwwjrtvyvmdasgn")
    public suspend fun configStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configStoreName = mapped
    }

    /**
     * @param value The location of the replica.
     */
    @JvmName("kdmlgdywxnxrouqs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the replica.
     */
    @JvmName("viintrgvuskdrkaq")
    public suspend fun replicaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("eesqugiumehiuhtw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ReplicaArgs = ReplicaArgs(
        configStoreName = configStoreName,
        location = location,
        replicaName = replicaName,
        resourceGroupName = resourceGroupName,
    )
}
