@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The private link service connection status.
 */
public enum class ConnectionStatus(
    public val javaValue: com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus> {
    Pending(com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.enums.ConnectionStatus): ConnectionStatus = ConnectionStatus.values().first { it.javaValue == javaType }
    }
}
