@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
 */
public enum class IdentityType(
    public val javaValue: com.pulumi.azurenative.appconfiguration.enums.IdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.enums.IdentityType> {
    None(com.pulumi.azurenative.appconfiguration.enums.IdentityType.None),
    SystemAssigned(com.pulumi.azurenative.appconfiguration.enums.IdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.appconfiguration.enums.IdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.appconfiguration.enums.IdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.appconfiguration.enums.IdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.enums.IdentityType): IdentityType = IdentityType.values().first { it.javaValue == javaType }
    }
}
