@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.appconfiguration.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.appconfiguration.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.appconfiguration.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.appconfiguration.enums.PublicNetworkAccess =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
