@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.GetConfigurationStorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configStoreName The name of the configuration store.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 */
public data class GetConfigurationStorePlainArgs(
    public val configStoreName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.GetConfigurationStorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.inputs.GetConfigurationStorePlainArgs =
        com.pulumi.azurenative.appconfiguration.inputs.GetConfigurationStorePlainArgs.builder()
            .configStoreName(configStoreName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationStorePlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationStorePlainArgsBuilder internal constructor() {
    private var configStoreName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("mgdjwqfopjlipbwn")
    public suspend fun configStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configStoreName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("orksegsvymolcuuc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationStorePlainArgs = GetConfigurationStorePlainArgs(
        configStoreName = configStoreName ?: throw PulumiNullFieldException("configStoreName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
