@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An API key used for authenticating with a configuration store endpoint.
 * @property connectionString A connection string that can be used by supporting clients for authentication.
 * @property id The key ID.
 * @property lastModified The last time any of the key's properties were modified.
 * @property name A name for the key describing its usage.
 * @property readOnly Whether this key can only be used for read operations.
 * @property value The value of the key that is used for authentication purposes.
 */
public data class ApiKeyResponse(
    public val connectionString: String,
    public val id: String,
    public val lastModified: String,
    public val name: String,
    public val readOnly: Boolean,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.ApiKeyResponse): ApiKeyResponse = ApiKeyResponse(
            connectionString = javaType.connectionString(),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            name = javaType.name(),
            readOnly = javaType.readOnly(),
            `value` = javaType.`value`(),
        )
    }
}
