@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings concerning key vault encryption for a configuration store.
 * @property identityClientId The client id of the identity which will be used to access key vault.
 * @property keyIdentifier The URI of the key vault key used to encrypt data.
 */
public data class KeyVaultPropertiesResponse(
    public val identityClientId: String? = null,
    public val keyIdentifier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            identityClientId = javaType.identityClientId().map({ args0 -> args0 }).orElse(null),
            keyIdentifier = javaType.keyIdentifier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
