@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ApiPortalPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ApiPortalPropertiesResponse.Companion.toKotlin as apiPortalPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ApiPortal].
 */
@PulumiTagMarker
public class ApiPortalResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiPortalArgs = ApiPortalArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiPortalArgsBuilder.() -> Unit) {
        val builder = ApiPortalArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiPortal {
        val builtJavaResource = com.pulumi.azurenative.appplatform.ApiPortal(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiPortal(builtJavaResource)
    }
}

/**
 * API portal resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### ApiPortals_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiPortal = new AzureNative.AppPlatform.ApiPortal("apiPortal", new()
 *     {
 *         ApiPortalName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.ApiPortalPropertiesArgs
 *         {
 *             GatewayIds = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/gateways/default",
 *             },
 *             Public = true,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApiPortal(ctx, "apiPortal", &appplatform.ApiPortalArgs{
 * 			ApiPortalName: pulumi.String("default"),
 * 			Properties: &appplatform.ApiPortalPropertiesArgs{
 * 				GatewayIds: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/gateways/default"),
 * 				},
 * 				Public: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ApiPortal;
 * import com.pulumi.azurenative.appplatform.ApiPortalArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ApiPortalPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiPortal = new ApiPortal("apiPortal", ApiPortalArgs.builder()
 *             .apiPortalName("default")
 *             .properties(ApiPortalPropertiesArgs.builder()
 *                 .gatewayIds("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/gateways/default")
 *                 .public_(true)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("E0")
 *                 .tier("Enterprise")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ApiPortal default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apiPortals/{apiPortalName}
 * ```
 */
public class ApiPortal internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ApiPortal,
) : KotlinCustomResource(javaResource, ApiPortalMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * API portal properties payload
     */
    public val properties: Output<ApiPortalPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                apiPortalPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the API portal resource
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiPortalMapper : ResourceMapper<ApiPortal> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ApiPortal::class == javaResource::class

    override fun map(javaResource: Resource): ApiPortal = ApiPortal(
        javaResource as
            com.pulumi.azurenative.appplatform.ApiPortal,
    )
}

/**
 * @see [ApiPortal].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiPortal].
 */
public suspend fun apiPortal(name: String, block: suspend ApiPortalResourceBuilder.() -> Unit): ApiPortal {
    val builder = ApiPortalResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiPortal].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiPortal(name: String): ApiPortal {
    val builder = ApiPortalResourceBuilder()
    builder.name(name)
    return builder.build()
}
