@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ApplicationAcceleratorArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Application accelerator resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### ApplicationAccelerators_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationAccelerator = new AzureNative.AppPlatform.ApplicationAccelerator("applicationAccelerator", new()
 *     {
 *         ApplicationAcceleratorName = "default",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApplicationAccelerator(ctx, "applicationAccelerator", &appplatform.ApplicationAcceleratorArgs{
 * 			ApplicationAcceleratorName: pulumi.String("default"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			ServiceName:                pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ApplicationAccelerator;
 * import com.pulumi.azurenative.appplatform.ApplicationAcceleratorArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationAccelerator = new ApplicationAccelerator("applicationAccelerator", ApplicationAcceleratorArgs.builder()
 *             .applicationAcceleratorName("default")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("E0")
 *                 .tier("Enterprise")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ApplicationAccelerator default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}
 * ```
 * @property applicationAcceleratorName The name of the application accelerator.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property sku Sku of the application accelerator resource
 */
public data class ApplicationAcceleratorArgs(
    public val applicationAcceleratorName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ApplicationAcceleratorArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ApplicationAcceleratorArgs =
        com.pulumi.azurenative.appplatform.ApplicationAcceleratorArgs.builder()
            .applicationAcceleratorName(applicationAcceleratorName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationAcceleratorArgs].
 */
@PulumiTagMarker
public class ApplicationAcceleratorArgsBuilder internal constructor() {
    private var applicationAcceleratorName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value The name of the application accelerator.
     */
    @JvmName("jvmykpgfiwfkfdtf")
    public suspend fun applicationAcceleratorName(`value`: Output<String>) {
        this.applicationAcceleratorName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ujleeyhgpxquokpn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ggqymwwqmnubpvim")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Sku of the application accelerator resource
     */
    @JvmName("ykuovdewipaqtnej")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of the application accelerator.
     */
    @JvmName("baobwqeqpaqeswtw")
    public suspend fun applicationAcceleratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationAcceleratorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rpkrrevfwvmonilp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("kcbnilewfiqidnnk")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Sku of the application accelerator resource
     */
    @JvmName("gbcitsoawtwubqew")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the application accelerator resource
     */
    @JvmName("nelfylgmeerfboli")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): ApplicationAcceleratorArgs = ApplicationAcceleratorArgs(
        applicationAcceleratorName = applicationAcceleratorName,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        sku = sku,
    )
}
