@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ContainerRegistryPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ContainerRegistryPropertiesResponse.Companion.toKotlin as containerRegistryPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContainerRegistry].
 */
@PulumiTagMarker
public class ContainerRegistryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerRegistryArgs = ContainerRegistryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerRegistryArgsBuilder.() -> Unit) {
        val builder = ContainerRegistryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContainerRegistry {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.ContainerRegistry(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContainerRegistry(builtJavaResource)
    }
}

/**
 * Container registry resource payload.
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### ContainerRegistries_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerRegistry = new AzureNative.AppPlatform.ContainerRegistry("containerRegistry", new()
 *     {
 *         ContainerRegistryName = "my-container-registry",
 *         Properties = new AzureNative.AppPlatform.Inputs.ContainerRegistryPropertiesArgs
 *         {
 *             Credentials = new AzureNative.AppPlatform.Inputs.ContainerRegistryBasicCredentialsArgs
 *             {
 *                 Password = "myPassword",
 *                 Server = "myServer",
 *                 Type = "BasicAuth",
 *                 Username = "myUsername",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "my-service",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewContainerRegistry(ctx, "containerRegistry", &appplatform.ContainerRegistryArgs{
 * ContainerRegistryName: pulumi.String("my-container-registry"),
 * Properties: &appplatform.ContainerRegistryPropertiesArgs{
 * Credentials: interface{}{
 * Password: pulumi.String("myPassword"),
 * Server: pulumi.String("myServer"),
 * Type: pulumi.String("BasicAuth"),
 * Username: pulumi.String("myUsername"),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("my-service"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ContainerRegistry;
 * import com.pulumi.azurenative.appplatform.ContainerRegistryArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ContainerRegistryPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ContainerRegistryBasicCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerRegistry = new ContainerRegistry("containerRegistry", ContainerRegistryArgs.builder()
 *             .containerRegistryName("my-container-registry")
 *             .properties(ContainerRegistryPropertiesArgs.builder()
 *                 .credentials(ContainerRegistryBasicCredentialsArgs.builder()
 *                     .password("myPassword")
 *                     .server("myServer")
 *                     .type("BasicAuth")
 *                     .username("myUsername")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("my-service")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ContainerRegistry my-container-registry /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/containerRegistries/{containerRegistryName}
 * ```
 */
public class ContainerRegistry internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ContainerRegistry,
) : KotlinCustomResource(javaResource, ContainerRegistryMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the container registry resource payload.
     */
    public val properties: Output<ContainerRegistryPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                containerRegistryPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContainerRegistryMapper : ResourceMapper<ContainerRegistry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ContainerRegistry::class == javaResource::class

    override fun map(javaResource: Resource): ContainerRegistry = ContainerRegistry(
        javaResource as
            com.pulumi.azurenative.appplatform.ContainerRegistry,
    )
}

/**
 * @see [ContainerRegistry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerRegistry].
 */
public suspend fun containerRegistry(
    name: String,
    block: suspend ContainerRegistryResourceBuilder.() -> Unit,
): ContainerRegistry {
    val builder = ContainerRegistryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerRegistry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerRegistry(name: String): ContainerRegistry {
    val builder = ContainerRegistryResourceBuilder()
    builder.name(name)
    return builder.build()
}
