@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ContainerRegistryArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ContainerRegistryPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ContainerRegistryPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container registry resource payload.
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### ContainerRegistries_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerRegistry = new AzureNative.AppPlatform.ContainerRegistry("containerRegistry", new()
 *     {
 *         ContainerRegistryName = "my-container-registry",
 *         Properties = new AzureNative.AppPlatform.Inputs.ContainerRegistryPropertiesArgs
 *         {
 *             Credentials = new AzureNative.AppPlatform.Inputs.ContainerRegistryBasicCredentialsArgs
 *             {
 *                 Password = "myPassword",
 *                 Server = "myServer",
 *                 Type = "BasicAuth",
 *                 Username = "myUsername",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "my-service",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewContainerRegistry(ctx, "containerRegistry", &appplatform.ContainerRegistryArgs{
 * ContainerRegistryName: pulumi.String("my-container-registry"),
 * Properties: &appplatform.ContainerRegistryPropertiesArgs{
 * Credentials: interface{}{
 * Password: pulumi.String("myPassword"),
 * Server: pulumi.String("myServer"),
 * Type: pulumi.String("BasicAuth"),
 * Username: pulumi.String("myUsername"),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("my-service"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ContainerRegistry;
 * import com.pulumi.azurenative.appplatform.ContainerRegistryArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ContainerRegistryPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ContainerRegistryBasicCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerRegistry = new ContainerRegistry("containerRegistry", ContainerRegistryArgs.builder()
 *             .containerRegistryName("my-container-registry")
 *             .properties(ContainerRegistryPropertiesArgs.builder()
 *                 .credentials(ContainerRegistryBasicCredentialsArgs.builder()
 *                     .password("myPassword")
 *                     .server("myServer")
 *                     .type("BasicAuth")
 *                     .username("myUsername")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("my-service")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ContainerRegistry my-container-registry /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/containerRegistries/{containerRegistryName}
 * ```
 * @property containerRegistryName The name of the container registry.
 * @property properties Properties of the container registry resource payload.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class ContainerRegistryArgs(
    public val containerRegistryName: Output<String>? = null,
    public val properties: Output<ContainerRegistryPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ContainerRegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ContainerRegistryArgs =
        com.pulumi.azurenative.appplatform.ContainerRegistryArgs.builder()
            .containerRegistryName(containerRegistryName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRegistryArgs].
 */
@PulumiTagMarker
public class ContainerRegistryArgsBuilder internal constructor() {
    private var containerRegistryName: Output<String>? = null

    private var properties: Output<ContainerRegistryPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("jombahfkdvvwufva")
    public suspend fun containerRegistryName(`value`: Output<String>) {
        this.containerRegistryName = value
    }

    /**
     * @param value Properties of the container registry resource payload.
     */
    @JvmName("wcquoldrpxkwjhnp")
    public suspend fun properties(`value`: Output<ContainerRegistryPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("aaouuiadyanouvkd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("aiwvfwuogeppygyv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("igaqralelnxpowin")
    public suspend fun containerRegistryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryName = mapped
    }

    /**
     * @param value Properties of the container registry resource payload.
     */
    @JvmName("wtlcklvgbudejakd")
    public suspend fun properties(`value`: ContainerRegistryPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the container registry resource payload.
     */
    @JvmName("fmdtrccykmmbenrs")
    public suspend fun properties(argument: suspend ContainerRegistryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRegistryPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sjfhotxpcdorkgja")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("fyqfchburaorlddr")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ContainerRegistryArgs = ContainerRegistryArgs(
        containerRegistryName = containerRegistryName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
