@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.CustomizedAcceleratorPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.CustomizedAcceleratorPropertiesResponse.Companion.toKotlin as customizedAcceleratorPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CustomizedAccelerator].
 */
@PulumiTagMarker
public class CustomizedAcceleratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomizedAcceleratorArgs = CustomizedAcceleratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomizedAcceleratorArgsBuilder.() -> Unit) {
        val builder = CustomizedAcceleratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomizedAccelerator {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.CustomizedAccelerator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomizedAccelerator(builtJavaResource)
    }
}

/**
 * Customized accelerator resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### CustomizedAccelerators_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customizedAccelerator = new AzureNative.AppPlatform.CustomizedAccelerator("customizedAccelerator", new()
 *     {
 *         ApplicationAcceleratorName = "default",
 *         CustomizedAcceleratorName = "acc-name",
 *         Properties = new AzureNative.AppPlatform.Inputs.CustomizedAcceleratorPropertiesArgs
 *         {
 *             AcceleratorTags = new[]
 *             {
 *                 "tag-a",
 *                 "tag-b",
 *             },
 *             Description = "acc-desc",
 *             DisplayName = "acc-name",
 *             GitRepository = new AzureNative.AppPlatform.Inputs.AcceleratorGitRepositoryArgs
 *             {
 *                 AuthSetting = new AzureNative.AppPlatform.Inputs.AcceleratorSshSettingArgs
 *                 {
 *                     AuthType = "SSH",
 *                     HostKey = "git-auth-hostkey",
 *                     HostKeyAlgorithm = "git-auth-algorithm",
 *                     PrivateKey = "git-auth-privatekey",
 *                 },
 *                 Branch = "git-branch",
 *                 Commit = "12345",
 *                 GitTag = "git-tag",
 *                 IntervalInSeconds = 70,
 *                 Url = "git-url",
 *             },
 *             IconUrl = "acc-icon",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewCustomizedAccelerator(ctx, "customizedAccelerator", &appplatform.CustomizedAcceleratorArgs{
 * 			ApplicationAcceleratorName: pulumi.String("default"),
 * 			CustomizedAcceleratorName:  pulumi.String("acc-name"),
 * 			Properties: &appplatform.CustomizedAcceleratorPropertiesArgs{
 * 				AcceleratorTags: pulumi.StringArray{
 * 					pulumi.String("tag-a"),
 * 					pulumi.String("tag-b"),
 * 				},
 * 				Description: pulumi.String("acc-desc"),
 * 				DisplayName: pulumi.String("acc-name"),
 * 				GitRepository: &appplatform.AcceleratorGitRepositoryArgs{
 * 					AuthSetting: appplatform.AcceleratorSshSetting{
 * 						AuthType:         "SSH",
 * 						HostKey:          "git-auth-hostkey",
 * 						HostKeyAlgorithm: "git-auth-algorithm",
 * 						PrivateKey:       "git-auth-privatekey",
 * 					},
 * 					Branch:            pulumi.String("git-branch"),
 * 					Commit:            pulumi.String("12345"),
 * 					GitTag:            pulumi.String("git-tag"),
 * 					IntervalInSeconds: pulumi.Int(70),
 * 					Url:               pulumi.String("git-url"),
 * 				},
 * 				IconUrl: pulumi.String("acc-icon"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.CustomizedAccelerator;
 * import com.pulumi.azurenative.appplatform.CustomizedAcceleratorArgs;
 * import com.pulumi.azurenative.appplatform.inputs.CustomizedAcceleratorPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.AcceleratorGitRepositoryArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customizedAccelerator = new CustomizedAccelerator("customizedAccelerator", CustomizedAcceleratorArgs.builder()
 *             .applicationAcceleratorName("default")
 *             .customizedAcceleratorName("acc-name")
 *             .properties(CustomizedAcceleratorPropertiesArgs.builder()
 *                 .acceleratorTags(
 *                     "tag-a",
 *                     "tag-b")
 *                 .description("acc-desc")
 *                 .displayName("acc-name")
 *                 .gitRepository(AcceleratorGitRepositoryArgs.builder()
 *                     .authSetting(AcceleratorBasicAuthSettingArgs.builder()
 *                         .authType("SSH")
 *                         .hostKey("git-auth-hostkey")
 *                         .hostKeyAlgorithm("git-auth-algorithm")
 *                         .privateKey("git-auth-privatekey")
 *                         .build())
 *                     .branch("git-branch")
 *                     .commit("12345")
 *                     .gitTag("git-tag")
 *                     .intervalInSeconds(70)
 *                     .url("git-url")
 *                     .build())
 *                 .iconUrl("acc-icon")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("E0")
 *                 .tier("Enterprise")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:CustomizedAccelerator default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}/customizedAccelerators/{customizedAcceleratorName}
 * ```
 */
public class CustomizedAccelerator internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.CustomizedAccelerator,
) : KotlinCustomResource(javaResource, CustomizedAcceleratorMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Customized accelerator properties payload
     */
    public val properties: Output<CustomizedAcceleratorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                customizedAcceleratorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the customized accelerator resource
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomizedAcceleratorMapper : ResourceMapper<CustomizedAccelerator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.CustomizedAccelerator::class == javaResource::class

    override fun map(javaResource: Resource): CustomizedAccelerator =
        CustomizedAccelerator(
            javaResource as
                com.pulumi.azurenative.appplatform.CustomizedAccelerator,
        )
}

/**
 * @see [CustomizedAccelerator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomizedAccelerator].
 */
public suspend fun customizedAccelerator(
    name: String,
    block: suspend CustomizedAcceleratorResourceBuilder.() -> Unit,
): CustomizedAccelerator {
    val builder = CustomizedAcceleratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomizedAccelerator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customizedAccelerator(name: String): CustomizedAccelerator {
    val builder = CustomizedAcceleratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
