@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.GatewayCustomDomainArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GatewayCustomDomainPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GatewayCustomDomainPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom domain of the Spring Cloud Gateway
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### GatewayCustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayCustomDomain = new AzureNative.AppPlatform.GatewayCustomDomain("gatewayCustomDomain", new()
 *     {
 *         DomainName = "myDomainName",
 *         GatewayName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.GatewayCustomDomainPropertiesArgs
 *         {
 *             Thumbprint = "*",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewGatewayCustomDomain(ctx, "gatewayCustomDomain", &appplatform.GatewayCustomDomainArgs{
 * 			DomainName:  pulumi.String("myDomainName"),
 * 			GatewayName: pulumi.String("default"),
 * 			Properties: &appplatform.GatewayCustomDomainPropertiesArgs{
 * 				Thumbprint: pulumi.String("*"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.GatewayCustomDomain;
 * import com.pulumi.azurenative.appplatform.GatewayCustomDomainArgs;
 * import com.pulumi.azurenative.appplatform.inputs.GatewayCustomDomainPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayCustomDomain = new GatewayCustomDomain("gatewayCustomDomain", GatewayCustomDomainArgs.builder()
 *             .domainName("myDomainName")
 *             .gatewayName("default")
 *             .properties(GatewayCustomDomainPropertiesArgs.builder()
 *                 .thumbprint("*")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:GatewayCustomDomain myDomainName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/domains/{domainName}
 * ```
 * @property domainName The name of the Spring Cloud Gateway custom domain.
 * @property gatewayName The name of Spring Cloud Gateway.
 * @property properties The properties of custom domain for Spring Cloud Gateway
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GatewayCustomDomainArgs(
    public val domainName: Output<String>? = null,
    public val gatewayName: Output<String>? = null,
    public val properties: Output<GatewayCustomDomainPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.GatewayCustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.GatewayCustomDomainArgs =
        com.pulumi.azurenative.appplatform.GatewayCustomDomainArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayCustomDomainArgs].
 */
@PulumiTagMarker
public class GatewayCustomDomainArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var gatewayName: Output<String>? = null

    private var properties: Output<GatewayCustomDomainPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the Spring Cloud Gateway custom domain.
     */
    @JvmName("mreankvnwbcyhvpb")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("ogdcfusanpqfjtus")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value The properties of custom domain for Spring Cloud Gateway
     */
    @JvmName("aokgeewjdhcxmhgi")
    public suspend fun properties(`value`: Output<GatewayCustomDomainPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("michygrhaufrcetn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("sswwjfgwblmdqocc")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the Spring Cloud Gateway custom domain.
     */
    @JvmName("kkunylynsohkjccw")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("exxqjdkrffpjcdpc")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value The properties of custom domain for Spring Cloud Gateway
     */
    @JvmName("nmosdyoshsovktxy")
    public suspend fun properties(`value`: GatewayCustomDomainPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of custom domain for Spring Cloud Gateway
     */
    @JvmName("sunoqhfmuycgvcfe")
    public suspend fun properties(argument: suspend GatewayCustomDomainPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayCustomDomainPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qefenphnriowrmlq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("crnnblcvineqgjvy")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayCustomDomainArgs = GatewayCustomDomainArgs(
        domainName = domainName,
        gatewayName = gatewayName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
