@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayRouteConfigPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayRouteConfigPropertiesResponse.Companion.toKotlin as gatewayRouteConfigPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GatewayRouteConfig].
 */
@PulumiTagMarker
public class GatewayRouteConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayRouteConfigArgs = GatewayRouteConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayRouteConfigArgsBuilder.() -> Unit) {
        val builder = GatewayRouteConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayRouteConfig {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.GatewayRouteConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayRouteConfig(builtJavaResource)
    }
}

/**
 * Spring Cloud Gateway route config resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### GatewayRouteConfigs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayRouteConfig = new AzureNative.AppPlatform.GatewayRouteConfig("gatewayRouteConfig", new()
 *     {
 *         GatewayName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.GatewayRouteConfigPropertiesArgs
 *         {
 *             AppResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myApp",
 *             OpenApi = new AzureNative.AppPlatform.Inputs.GatewayRouteConfigOpenApiPropertiesArgs
 *             {
 *                 Uri = "https://raw.githubusercontent.com/OAI/OpenAPI-Specification/main/examples/v3.0/petstore.json",
 *             },
 *             Protocol = AzureNative.AppPlatform.GatewayRouteConfigProtocol.HTTPS,
 *             Routes = new[]
 *             {
 *                 new AzureNative.AppPlatform.Inputs.GatewayApiRouteArgs
 *                 {
 *                     Filters = new[]
 *                     {
 *                         "StripPrefix=2",
 *                         "RateLimit=1,1s",
 *                     },
 *                     Predicates = new[]
 *                     {
 *                         "Path=/api5/customer/**",
 *                     },
 *                     SsoEnabled = true,
 *                     Title = "myApp route config",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RouteConfigName = "myRouteConfig",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewGatewayRouteConfig(ctx, "gatewayRouteConfig", &appplatform.GatewayRouteConfigArgs{
 * 			GatewayName: pulumi.String("default"),
 * 			Properties: &appplatform.GatewayRouteConfigPropertiesArgs{
 * 				AppResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myApp"),
 * 				OpenApi: &appplatform.GatewayRouteConfigOpenApiPropertiesArgs{
 * 					Uri: pulumi.String("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/main/examples/v3.0/petstore.json"),
 * 				},
 * 				Protocol: pulumi.String(appplatform.GatewayRouteConfigProtocolHTTPS),
 * 				Routes: appplatform.GatewayApiRouteArray{
 * 					&appplatform.GatewayApiRouteArgs{
 * 						Filters: pulumi.StringArray{
 * 							pulumi.String("StripPrefix=2"),
 * 							pulumi.String("RateLimit=1,1s"),
 * 						},
 * 						Predicates: pulumi.StringArray{
 * 							pulumi.String("Path=/api5/customer/**"),
 * 						},
 * 						SsoEnabled: pulumi.Bool(true),
 * 						Title:      pulumi.String("myApp route config"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RouteConfigName:   pulumi.String("myRouteConfig"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.GatewayRouteConfig;
 * import com.pulumi.azurenative.appplatform.GatewayRouteConfigArgs;
 * import com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigOpenApiPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayRouteConfig = new GatewayRouteConfig("gatewayRouteConfig", GatewayRouteConfigArgs.builder()
 *             .gatewayName("default")
 *             .properties(GatewayRouteConfigPropertiesArgs.builder()
 *                 .appResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myApp")
 *                 .openApi(GatewayRouteConfigOpenApiPropertiesArgs.builder()
 *                     .uri("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/main/examples/v3.0/petstore.json")
 *                     .build())
 *                 .protocol("HTTPS")
 *                 .routes(GatewayApiRouteArgs.builder()
 *                     .filters(
 *                         "StripPrefix=2",
 *                         "RateLimit=1,1s")
 *                     .predicates("Path=/api5/customer/**")
 *                     .ssoEnabled(true)
 *                     .title("myApp route config")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .routeConfigName("myRouteConfig")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:GatewayRouteConfig myRouteConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}
 * ```
 * */*/*/
 */
public class GatewayRouteConfig internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.GatewayRouteConfig,
) : KotlinCustomResource(javaResource, GatewayRouteConfigMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * API route config of the Spring Cloud Gateway
     */
    public val properties: Output<GatewayRouteConfigPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayRouteConfigPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GatewayRouteConfigMapper : ResourceMapper<GatewayRouteConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.GatewayRouteConfig::class == javaResource::class

    override fun map(javaResource: Resource): GatewayRouteConfig = GatewayRouteConfig(
        javaResource as
            com.pulumi.azurenative.appplatform.GatewayRouteConfig,
    )
}

/**
 * @see [GatewayRouteConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayRouteConfig].
 */
public suspend fun gatewayRouteConfig(
    name: String,
    block: suspend GatewayRouteConfigResourceBuilder.() -> Unit,
): GatewayRouteConfig {
    val builder = GatewayRouteConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayRouteConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayRouteConfig(name: String): GatewayRouteConfig {
    val builder = GatewayRouteConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
