@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.GatewayRouteConfigArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GatewayRouteConfigPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GatewayRouteConfigPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Spring Cloud Gateway route config resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### GatewayRouteConfigs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayRouteConfig = new AzureNative.AppPlatform.GatewayRouteConfig("gatewayRouteConfig", new()
 *     {
 *         GatewayName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.GatewayRouteConfigPropertiesArgs
 *         {
 *             AppResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myApp",
 *             OpenApi = new AzureNative.AppPlatform.Inputs.GatewayRouteConfigOpenApiPropertiesArgs
 *             {
 *                 Uri = "https://raw.githubusercontent.com/OAI/OpenAPI-Specification/main/examples/v3.0/petstore.json",
 *             },
 *             Protocol = AzureNative.AppPlatform.GatewayRouteConfigProtocol.HTTPS,
 *             Routes = new[]
 *             {
 *                 new AzureNative.AppPlatform.Inputs.GatewayApiRouteArgs
 *                 {
 *                     Filters = new[]
 *                     {
 *                         "StripPrefix=2",
 *                         "RateLimit=1,1s",
 *                     },
 *                     Predicates = new[]
 *                     {
 *                         "Path=/api5/customer/**",
 *                     },
 *                     SsoEnabled = true,
 *                     Title = "myApp route config",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RouteConfigName = "myRouteConfig",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewGatewayRouteConfig(ctx, "gatewayRouteConfig", &appplatform.GatewayRouteConfigArgs{
 * 			GatewayName: pulumi.String("default"),
 * 			Properties: &appplatform.GatewayRouteConfigPropertiesArgs{
 * 				AppResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myApp"),
 * 				OpenApi: &appplatform.GatewayRouteConfigOpenApiPropertiesArgs{
 * 					Uri: pulumi.String("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/main/examples/v3.0/petstore.json"),
 * 				},
 * 				Protocol: pulumi.String(appplatform.GatewayRouteConfigProtocolHTTPS),
 * 				Routes: appplatform.GatewayApiRouteArray{
 * 					&appplatform.GatewayApiRouteArgs{
 * 						Filters: pulumi.StringArray{
 * 							pulumi.String("StripPrefix=2"),
 * 							pulumi.String("RateLimit=1,1s"),
 * 						},
 * 						Predicates: pulumi.StringArray{
 * 							pulumi.String("Path=/api5/customer/**"),
 * 						},
 * 						SsoEnabled: pulumi.Bool(true),
 * 						Title:      pulumi.String("myApp route config"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RouteConfigName:   pulumi.String("myRouteConfig"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.GatewayRouteConfig;
 * import com.pulumi.azurenative.appplatform.GatewayRouteConfigArgs;
 * import com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigOpenApiPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayRouteConfig = new GatewayRouteConfig("gatewayRouteConfig", GatewayRouteConfigArgs.builder()
 *             .gatewayName("default")
 *             .properties(GatewayRouteConfigPropertiesArgs.builder()
 *                 .appResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apps/myApp")
 *                 .openApi(GatewayRouteConfigOpenApiPropertiesArgs.builder()
 *                     .uri("https://raw.githubusercontent.com/OAI/OpenAPI-Specification/main/examples/v3.0/petstore.json")
 *                     .build())
 *                 .protocol("HTTPS")
 *                 .routes(GatewayApiRouteArgs.builder()
 *                     .filters(
 *                         "StripPrefix=2",
 *                         "RateLimit=1,1s")
 *                     .predicates("Path=/api5/customer/**")
 *                     .ssoEnabled(true)
 *                     .title("myApp route config")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .routeConfigName("myRouteConfig")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:GatewayRouteConfig myRouteConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/routeConfigs/{routeConfigName}
 * ```
 * @property gatewayName The name of Spring Cloud Gateway.
 * @property properties API route config of the Spring Cloud Gateway
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property routeConfigName The name of the Spring Cloud Gateway route config.
 * @property serviceName The name of the Service resource.
 * */*/*/
 */
public data class GatewayRouteConfigArgs(
    public val gatewayName: Output<String>? = null,
    public val properties: Output<GatewayRouteConfigPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeConfigName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.GatewayRouteConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.GatewayRouteConfigArgs =
        com.pulumi.azurenative.appplatform.GatewayRouteConfigArgs.builder()
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeConfigName(routeConfigName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteConfigArgs].
 */
@PulumiTagMarker
public class GatewayRouteConfigArgsBuilder internal constructor() {
    private var gatewayName: Output<String>? = null

    private var properties: Output<GatewayRouteConfigPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeConfigName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("fackpmsfdeukharu")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value API route config of the Spring Cloud Gateway
     */
    @JvmName("vrxmnuloymcttjbw")
    public suspend fun properties(`value`: Output<GatewayRouteConfigPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("unqkexblvxalbtsy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Spring Cloud Gateway route config.
     */
    @JvmName("dopfpgkhtojmeemx")
    public suspend fun routeConfigName(`value`: Output<String>) {
        this.routeConfigName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("usfoinalrvsmskhi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("gjcrgsusdegxeasi")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value API route config of the Spring Cloud Gateway
     */
    @JvmName("ktavpoepajaupoex")
    public suspend fun properties(`value`: GatewayRouteConfigPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument API route config of the Spring Cloud Gateway
     */
    @JvmName("aoyoxurmruqvpbel")
    public suspend fun properties(argument: suspend GatewayRouteConfigPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteConfigPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("khphkdljmmgwcqki")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Spring Cloud Gateway route config.
     */
    @JvmName("kkecqrogpnkwuwdv")
    public suspend fun routeConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeConfigName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("kxmnhfafhhaehjtx")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayRouteConfigArgs = GatewayRouteConfigArgs(
        gatewayName = gatewayName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        routeConfigName = routeConfigName,
        serviceName = serviceName,
    )
}
