@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.JobResourcePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.JobResourcePropertiesResponse.Companion.toKotlin as jobResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * Job resource payload
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Job_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.AppPlatform.Job("job", new()
 *     {
 *         JobName = "test-job",
 *         Properties = new AzureNative.AppPlatform.Inputs.JobResourcePropertiesArgs
 *         {
 *             Source = new AzureNative.AppPlatform.Inputs.BuildResultUserSourceInfoArgs
 *             {
 *                 BuildResultId = "<default>",
 *                 Type = "BuildResult",
 *             },
 *             Template = new AzureNative.AppPlatform.Inputs.JobExecutionTemplateArgs
 *             {
 *                 Args = new[]
 *                 {
 *                     "arg1",
 *                     "arg2",
 *                 },
 *                 EnvironmentVariables = new[]
 *                 {
 *                     new AzureNative.AppPlatform.Inputs.EnvVarArgs
 *                     {
 *                         Name = "key1",
 *                         Value = "value1",
 *                     },
 *                     new AzureNative.AppPlatform.Inputs.EnvVarArgs
 *                     {
 *                         Name = "env2",
 *                         Value = "value2",
 *                     },
 *                     new AzureNative.AppPlatform.Inputs.EnvVarArgs
 *                     {
 *                         Name = "secretKey1",
 *                         SecretValue = "secretValue1",
 *                     },
 *                 },
 *             },
 *             TriggerConfig = new AzureNative.AppPlatform.Inputs.ManualJobTriggerConfigArgs
 *             {
 *                 TriggerType = "Manual",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewJob(ctx, "job", &appplatform.JobArgs{
 * JobName: pulumi.String("test-job"),
 * Properties: &appplatform.JobResourcePropertiesArgs{
 * Source: appplatform.BuildResultUserSourceInfo{
 * BuildResultId: "<default>",
 * Type: "BuildResult",
 * },
 * Template: &appplatform.JobExecutionTemplateArgs{
 * Args: pulumi.StringArray{
 * pulumi.String("arg1"),
 * pulumi.String("arg2"),
 * },
 * EnvironmentVariables: appplatform.EnvVarArray{
 * &appplatform.EnvVarArgs{
 * Name: pulumi.String("key1"),
 * Value: pulumi.String("value1"),
 * },
 * &appplatform.EnvVarArgs{
 * Name: pulumi.String("env2"),
 * Value: pulumi.String("value2"),
 * },
 * &appplatform.EnvVarArgs{
 * Name: pulumi.String("secretKey1"),
 * SecretValue: pulumi.String("secretValue1"),
 * },
 * },
 * },
 * TriggerConfig: interface{}{
 * TriggerType: pulumi.String("Manual"),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Job;
 * import com.pulumi.azurenative.appplatform.JobArgs;
 * import com.pulumi.azurenative.appplatform.inputs.JobResourcePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.JobExecutionTemplateArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ManualJobTriggerConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobName("test-job")
 *             .properties(JobResourcePropertiesArgs.builder()
 *                 .source(BuildResultUserSourceInfoArgs.builder()
 *                     .buildResultId("<default>")
 *                     .type("BuildResult")
 *                     .build())
 *                 .template(JobExecutionTemplateArgs.builder()
 *                     .args(
 *                         "arg1",
 *                         "arg2")
 *                     .environmentVariables(
 *                         EnvVarArgs.builder()
 *                             .name("key1")
 *                             .value("value1")
 *                             .build(),
 *                         EnvVarArgs.builder()
 *                             .name("env2")
 *                             .value("value2")
 *                             .build(),
 *                         EnvVarArgs.builder()
 *                             .name("secretKey1")
 *                             .secretValue("secretValue1")
 *                             .build())
 *                     .build())
 *                 .triggerConfig(ManualJobTriggerConfigArgs.builder()
 *                     .triggerType("Manual")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Job test-job /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the Job resource
     */
    public val properties: Output<JobResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                jobResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.appplatform.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
