@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.JobArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.JobResourcePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.JobResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Job resource payload
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Job_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.AppPlatform.Job("job", new()
 *     {
 *         JobName = "test-job",
 *         Properties = new AzureNative.AppPlatform.Inputs.JobResourcePropertiesArgs
 *         {
 *             Source = new AzureNative.AppPlatform.Inputs.BuildResultUserSourceInfoArgs
 *             {
 *                 BuildResultId = "<default>",
 *                 Type = "BuildResult",
 *             },
 *             Template = new AzureNative.AppPlatform.Inputs.JobExecutionTemplateArgs
 *             {
 *                 Args = new[]
 *                 {
 *                     "arg1",
 *                     "arg2",
 *                 },
 *                 EnvironmentVariables = new[]
 *                 {
 *                     new AzureNative.AppPlatform.Inputs.EnvVarArgs
 *                     {
 *                         Name = "key1",
 *                         Value = "value1",
 *                     },
 *                     new AzureNative.AppPlatform.Inputs.EnvVarArgs
 *                     {
 *                         Name = "env2",
 *                         Value = "value2",
 *                     },
 *                     new AzureNative.AppPlatform.Inputs.EnvVarArgs
 *                     {
 *                         Name = "secretKey1",
 *                         SecretValue = "secretValue1",
 *                     },
 *                 },
 *             },
 *             TriggerConfig = new AzureNative.AppPlatform.Inputs.ManualJobTriggerConfigArgs
 *             {
 *                 TriggerType = "Manual",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewJob(ctx, "job", &appplatform.JobArgs{
 * JobName: pulumi.String("test-job"),
 * Properties: &appplatform.JobResourcePropertiesArgs{
 * Source: appplatform.BuildResultUserSourceInfo{
 * BuildResultId: "<default>",
 * Type: "BuildResult",
 * },
 * Template: &appplatform.JobExecutionTemplateArgs{
 * Args: pulumi.StringArray{
 * pulumi.String("arg1"),
 * pulumi.String("arg2"),
 * },
 * EnvironmentVariables: appplatform.EnvVarArray{
 * &appplatform.EnvVarArgs{
 * Name: pulumi.String("key1"),
 * Value: pulumi.String("value1"),
 * },
 * &appplatform.EnvVarArgs{
 * Name: pulumi.String("env2"),
 * Value: pulumi.String("value2"),
 * },
 * &appplatform.EnvVarArgs{
 * Name: pulumi.String("secretKey1"),
 * SecretValue: pulumi.String("secretValue1"),
 * },
 * },
 * },
 * TriggerConfig: interface{}{
 * TriggerType: pulumi.String("Manual"),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Job;
 * import com.pulumi.azurenative.appplatform.JobArgs;
 * import com.pulumi.azurenative.appplatform.inputs.JobResourcePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.JobExecutionTemplateArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ManualJobTriggerConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobName("test-job")
 *             .properties(JobResourcePropertiesArgs.builder()
 *                 .source(BuildResultUserSourceInfoArgs.builder()
 *                     .buildResultId("<default>")
 *                     .type("BuildResult")
 *                     .build())
 *                 .template(JobExecutionTemplateArgs.builder()
 *                     .args(
 *                         "arg1",
 *                         "arg2")
 *                     .environmentVariables(
 *                         EnvVarArgs.builder()
 *                             .name("key1")
 *                             .value("value1")
 *                             .build(),
 *                         EnvVarArgs.builder()
 *                             .name("env2")
 *                             .value("value2")
 *                             .build(),
 *                         EnvVarArgs.builder()
 *                             .name("secretKey1")
 *                             .secretValue("secretValue1")
 *                             .build())
 *                     .build())
 *                 .triggerConfig(ManualJobTriggerConfigArgs.builder()
 *                     .triggerType("Manual")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Job test-job /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/jobs/{jobName}
 * ```
 * @property jobName The name of the Job resource.
 * @property properties Properties of the Job resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class JobArgs(
    public val jobName: Output<String>? = null,
    public val properties: Output<JobResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.JobArgs =
        com.pulumi.azurenative.appplatform.JobArgs.builder()
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var jobName: Output<String>? = null

    private var properties: Output<JobResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the Job resource.
     */
    @JvmName("eurlpdtafslmjdai")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Properties of the Job resource
     */
    @JvmName("nlyklnhjeenjmjkt")
    public suspend fun properties(`value`: Output<JobResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("oqmdlrsyiocjeasr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("jdxotuwyqvkohmgk")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the Job resource.
     */
    @JvmName("njvplsjrwttrmqur")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Properties of the Job resource
     */
    @JvmName("jvvdvmpptsrabiie")
    public suspend fun properties(`value`: JobResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Job resource
     */
    @JvmName("urmhalxfnmxolhrg")
    public suspend fun properties(argument: suspend JobResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = JobResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wrrinawkgrwegonb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("sedqypspssitvvlr")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        jobName = jobName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
