@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ServiceRegistryPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ServiceRegistryPropertiesResponse.Companion.toKotlin as serviceRegistryPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ServiceRegistry].
 */
@PulumiTagMarker
public class ServiceRegistryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceRegistryArgs = ServiceRegistryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceRegistryArgsBuilder.() -> Unit) {
        val builder = ServiceRegistryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceRegistry {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.ServiceRegistry(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceRegistry(builtJavaResource)
    }
}

/**
 * Service Registry resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### ServiceRegistries_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceRegistry = new AzureNative.AppPlatform.ServiceRegistry("serviceRegistry", new()
 *     {
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         ServiceRegistryName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewServiceRegistry(ctx, "serviceRegistry", &appplatform.ServiceRegistryArgs{
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceName:         pulumi.String("myservice"),
 * 			ServiceRegistryName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ServiceRegistry;
 * import com.pulumi.azurenative.appplatform.ServiceRegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceRegistry = new ServiceRegistry("serviceRegistry", ServiceRegistryArgs.builder()
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .serviceRegistryName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ServiceRegistry default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/serviceRegistries/{serviceRegistryName}
 * ```
 */
public class ServiceRegistry internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ServiceRegistry,
) : KotlinCustomResource(javaResource, ServiceRegistryMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Service Registry properties payload
     */
    public val properties: Output<ServiceRegistryPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceRegistryPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceRegistryMapper : ResourceMapper<ServiceRegistry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ServiceRegistry::class == javaResource::class

    override fun map(javaResource: Resource): ServiceRegistry = ServiceRegistry(
        javaResource as
            com.pulumi.azurenative.appplatform.ServiceRegistry,
    )
}

/**
 * @see [ServiceRegistry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceRegistry].
 */
public suspend fun serviceRegistry(
    name: String,
    block: suspend ServiceRegistryResourceBuilder.() -> Unit,
): ServiceRegistry {
    val builder = ServiceRegistryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceRegistry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceRegistry(name: String): ServiceRegistry {
    val builder = ServiceRegistryResourceBuilder()
    builder.name(name)
    return builder.build()
}
