@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.StorageAccountResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.StorageAccountResponse.Companion.toKotlin as storageAccountResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Storage].
 */
@PulumiTagMarker
public class StorageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageArgs = StorageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageArgsBuilder.() -> Unit) {
        val builder = StorageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Storage {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Storage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Storage(builtJavaResource)
    }
}

/**
 * Storage resource payload.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2021-09-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### Storages_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storage = new AzureNative.AppPlatform.Storage("storage", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.StorageAccountArgs
 *         {
 *             AccountKey = "account-key-of-storage-account",
 *             AccountName = "storage-account-name",
 *             StorageType = "StorageAccount",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         StorageName = "mystorage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewStorage(ctx, "storage", &appplatform.StorageArgs{
 * 			Properties: &appplatform.StorageAccountArgs{
 * 				AccountKey:  pulumi.String("account-key-of-storage-account"),
 * 				AccountName: pulumi.String("storage-account-name"),
 * 				StorageType: pulumi.String("StorageAccount"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			StorageName:       pulumi.String("mystorage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Storage;
 * import com.pulumi.azurenative.appplatform.StorageArgs;
 * import com.pulumi.azurenative.appplatform.inputs.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storage = new Storage("storage", StorageArgs.builder()
 *             .properties(StorageAccountArgs.builder()
 *                 .accountKey("account-key-of-storage-account")
 *                 .accountName("storage-account-name")
 *                 .storageType("StorageAccount")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .storageName("mystorage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Storage mystorage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/storages/{storageName}
 * ```
 */
public class Storage internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Storage,
) : KotlinCustomResource(javaResource, StorageMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the storage resource payload.
     */
    public val properties: Output<StorageAccountResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                storageAccountResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageMapper : ResourceMapper<Storage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Storage::class == javaResource::class

    override fun map(javaResource: Resource): Storage = Storage(
        javaResource as
            com.pulumi.azurenative.appplatform.Storage,
    )
}

/**
 * @see [Storage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Storage].
 */
public suspend fun storage(name: String, block: suspend StorageResourceBuilder.() -> Unit): Storage {
    val builder = StorageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Storage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storage(name: String): Storage {
    val builder = StorageResourceBuilder()
    builder.name(name)
    return builder.build()
}
