@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.StorageArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.StorageAccountArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.StorageAccountArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage resource payload.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2021-09-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### Storages_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storage = new AzureNative.AppPlatform.Storage("storage", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.StorageAccountArgs
 *         {
 *             AccountKey = "account-key-of-storage-account",
 *             AccountName = "storage-account-name",
 *             StorageType = "StorageAccount",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         StorageName = "mystorage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewStorage(ctx, "storage", &appplatform.StorageArgs{
 * 			Properties: &appplatform.StorageAccountArgs{
 * 				AccountKey:  pulumi.String("account-key-of-storage-account"),
 * 				AccountName: pulumi.String("storage-account-name"),
 * 				StorageType: pulumi.String("StorageAccount"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			StorageName:       pulumi.String("mystorage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Storage;
 * import com.pulumi.azurenative.appplatform.StorageArgs;
 * import com.pulumi.azurenative.appplatform.inputs.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storage = new Storage("storage", StorageArgs.builder()
 *             .properties(StorageAccountArgs.builder()
 *                 .accountKey("account-key-of-storage-account")
 *                 .accountName("storage-account-name")
 *                 .storageType("StorageAccount")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .storageName("mystorage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Storage mystorage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/storages/{storageName}
 * ```
 * @property properties Properties of the storage resource payload.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property storageName The name of the storage resource.
 */
public data class StorageArgs(
    public val properties: Output<StorageAccountArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val storageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.StorageArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.StorageArgs =
        com.pulumi.azurenative.appplatform.StorageArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .storageName(storageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageArgs].
 */
@PulumiTagMarker
public class StorageArgsBuilder internal constructor() {
    private var properties: Output<StorageAccountArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var storageName: Output<String>? = null

    /**
     * @param value Properties of the storage resource payload.
     */
    @JvmName("jpmxfyibmkulebxa")
    public suspend fun properties(`value`: Output<StorageAccountArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ptqkvtwyotmoodgm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("amniahxttwpqopmk")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the storage resource.
     */
    @JvmName("wanyqwfljpnvukfy")
    public suspend fun storageName(`value`: Output<String>) {
        this.storageName = value
    }

    /**
     * @param value Properties of the storage resource payload.
     */
    @JvmName("afmxbhfhatobmute")
    public suspend fun properties(`value`: StorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the storage resource payload.
     */
    @JvmName("ahcmgoanllvnukjk")
    public suspend fun properties(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dyhctcnxeovdeujx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("vhbfssfjovecyhde")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the storage resource.
     */
    @JvmName("rhdevhbrhygewkyv")
    public suspend fun storageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageName = mapped
    }

    internal fun build(): StorageArgs = StorageArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        storageName = storageName,
    )
}
