@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of application performance monitoring
 */
public enum class ApmType(
    public val javaValue: com.pulumi.azurenative.appplatform.enums.ApmType,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.enums.ApmType> {
    ApplicationInsights(com.pulumi.azurenative.appplatform.enums.ApmType.ApplicationInsights),
    AppDynamics(com.pulumi.azurenative.appplatform.enums.ApmType.AppDynamics),
    Dynatrace(com.pulumi.azurenative.appplatform.enums.ApmType.Dynatrace),
    NewRelic(com.pulumi.azurenative.appplatform.enums.ApmType.NewRelic),
    ElasticAPM(com.pulumi.azurenative.appplatform.enums.ApmType.ElasticAPM),
    ;

    override fun toJava(): com.pulumi.azurenative.appplatform.enums.ApmType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.enums.ApmType): ApmType =
            ApmType.values().first { it.javaValue == javaType }
    }
}
