@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enabled state of the config server. This is only used in Consumption tier.
 */
public enum class ConfigServerEnabledState(
    public val javaValue: com.pulumi.azurenative.appplatform.enums.ConfigServerEnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.enums.ConfigServerEnabledState> {
    /**
     * Enable the config server.
     */
    Enabled(com.pulumi.azurenative.appplatform.enums.ConfigServerEnabledState.Enabled),

    /**
     * Disable the config server.
     */
    Disabled(com.pulumi.azurenative.appplatform.enums.ConfigServerEnabledState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.appplatform.enums.ConfigServerEnabledState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.enums.ConfigServerEnabledState): ConfigServerEnabledState =
            ConfigServerEnabledState.values().first { it.javaValue == javaType }
    }
}
