@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to enable certificate verification or not
 */
public enum class GatewayCertificateVerification(
    public val javaValue: com.pulumi.azurenative.appplatform.enums.GatewayCertificateVerification,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.enums.GatewayCertificateVerification> {
    /**
     * Enable certificate verification in Spring Cloud Gateway.
     */
    Enabled(com.pulumi.azurenative.appplatform.enums.GatewayCertificateVerification.Enabled),

    /**
     * Disable certificate verification in Spring Cloud Gateway.
     */
    Disabled(com.pulumi.azurenative.appplatform.enums.GatewayCertificateVerification.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.appplatform.enums.GatewayCertificateVerification =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.enums.GatewayCertificateVerification): GatewayCertificateVerification =
            GatewayCertificateVerification.values().first { it.javaValue == javaType }
    }
}
