@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AcceleratorBasicAuthSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auth setting for basic auth.
 * @property authType The type of the auth setting.
 * Expected value is 'BasicAuth'.
 * @property caCertResourceId Resource Id of CA certificate for https URL of Git repository.
 * @property password Password of git repository basic auth.
 * @property username Username of git repository basic auth.
 */
public data class AcceleratorBasicAuthSettingArgs(
    public val authType: Output<String>,
    public val caCertResourceId: Output<String>? = null,
    public val password: Output<String>? = null,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AcceleratorBasicAuthSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AcceleratorBasicAuthSettingArgs =
        com.pulumi.azurenative.appplatform.inputs.AcceleratorBasicAuthSettingArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .caCertResourceId(caCertResourceId?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AcceleratorBasicAuthSettingArgs].
 */
@PulumiTagMarker
public class AcceleratorBasicAuthSettingArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var caCertResourceId: Output<String>? = null

    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The type of the auth setting.
     * Expected value is 'BasicAuth'.
     */
    @JvmName("jkhvcfaojdatfapu")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Resource Id of CA certificate for https URL of Git repository.
     */
    @JvmName("annairpciiunafag")
    public suspend fun caCertResourceId(`value`: Output<String>) {
        this.caCertResourceId = value
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("rdpvmlxxsahvrbrr")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("cdipomlkuaoucnva")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The type of the auth setting.
     * Expected value is 'BasicAuth'.
     */
    @JvmName("kogmocsrsacxadtb")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Resource Id of CA certificate for https URL of Git repository.
     */
    @JvmName("stxqsnhyxphneitr")
    public suspend fun caCertResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertResourceId = mapped
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("ntvbllibnuottvvh")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("iqkhoymooqqxqyvy")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): AcceleratorBasicAuthSettingArgs = AcceleratorBasicAuthSettingArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        caCertResourceId = caCertResourceId,
        password = password,
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
